/**
 * 发起流程 -- 新的流程部署
 */
import http from '../http'
import { https } from '../https'

export default {
  // 获取流程的启动表单
  renderedStartForm: data =>
    http
      .get(
        '/flow/v1/processInstance/renderedStartForm?processDefinitionId=' + data
      )
      .then(res => res),
  // 启动流程实例
  start: data =>
    https
      .post('/flow/v1/processInstance/start', JSON.stringify(data))
      .then(res => res),
  // 查看-流程表单
  formData: id =>
    http
      .get('/flow/v1/processInstance/formData?processInstanceId=' + id)
      .then(res => res)
}
