/**
 * 工作台
 */

import http from '../http'
import { https } from '../https'

export default {
  // page
  page: data => http.post('meter/v1/contract/page', data).then(res => res),
  pageHis: data =>
    http
      .post('meter/v1/contract/page_quote_register_his', data)
      .then(res => res),

  pageQuoteFirstReview: data =>
    http
      .post('meter/v1/contract/page_quote_first_review', data)
      .then(res => res),
  pageQuoteFirstReviewHis: data =>
    http
      .post('meter/v1/contract/page_quote_first_review_his', data)
      .then(res => res),
  pageQuoteSecondReview: data =>
    http
      .post('meter/v1/contract/page_quote_second_review', data)
      .then(res => res),
  pageQuoteSecondReviewHis: data =>
    http
      .post('meter/v1/contract/page_quote_second_review_his', data)
      .then(res => res),
  pageQuoteThirdReview: data =>
    http
      .post('meter/v1/contract/page_quote_third_review', data)
      .then(res => res),
  pageQuoteThirdReviewHis: data =>
    http
      .post('meter/v1/contract/page_quote_third_review_his', data)
      .then(res => res),
  pageAccepted: data =>
    http.post('meter/v1/contract/page_accepted', data).then(res => res),
  pageAcceptedHis: data =>
    http.post('meter/v1/contract/page_accepted_his', data).then(res => res),

  pageContractRegister: data =>
    http
      .post('meter/v1/contract/page_contract_register', data)
      .then(res => res),
  pageContractReview: data =>
    http.post('meter/v1/contract/page_contract_review', data).then(res => res),

  pageContractFile: data =>
    http.post('meter/v1/contract/page_contract_file', data).then(res => res),

  submitQuoteFirstReview: data =>
    http
      .post('meter/v1/contract/submit_to_review_first?ids=' + data)
      .then(res => res),

  submitToContractRegister: data =>
    http
      .post('meter/v1/contract/submit_to_contract_register?ids=' + data)
      .then(res => res),

  submitToReviewThird: data =>
    http
      .post('meter/v1/contract/submit_to_review_third?ids=' + data)
      .then(res => res),
  submitToAccepted: data =>
    http
      .post('meter/v1/contract/submit_to_accepted?ids=' + data)
      .then(res => res),

  submitToContractReview: data =>
    http
      .post('meter/v1/contract/submit_to_contract_review?ids=' + data)
      .then(res => res),

  submitToReviewSecond: data =>
    http
      .post('meter/v1/contract/submit_to_review_second?ids=' + data)
      .then(res => res),
  getById: data => http.get('meter/v1/contract/' + data).then(res => res),
  getVOById: data => http.get('meter/v1/contract/vo/' + data).then(res => res),
  // 删除
  deleteById: data =>
    http.delete('meter/v1/contract/?ids=' + data).then(res => res),
  // 初审退回
  check: data =>
    http
      .post(
        'meter/v1/contract/back_to_review_first?ids=' +
          data.ids +
          '&remark=' +
          data.remark
      )
      .then(res => res),
  // 复审退回
  checkSecond: data =>
    http
      .post(
        'meter/v1/contract/back_review_second?ids=' +
          data.ids +
          '&remark=' +
          data.remark
      )
      .then(res => res),
  // 报价单批准退回
  approve: data =>
    http
      .post(
        'meter/v1/contract/back_review_third?ids=' +
          data.ids +
          '&remark=' +
          data.remark
      )
      .then(res => res),

  editDTO: data =>
    https
      .post('meter/v1/contract/edit_quote', JSON.stringify(data))
      .then(res => res),
  // 业务受理退回
  reception: data =>
    http
      .post(
        'meter/v1/contract/back_accepted?ids=' +
          data.ids +
          '&remark=' +
          data.remark
      )
      .then(res => res),
  // 保存
  save: data =>
    https
      .post('meter/v1/contract/add_aptitude', JSON.stringify(data))
      .then(res => res),
  // 编辑
  edit: data =>
    http.put('meter/v1/contract/' + data.id, data.obj).then(res => res),

  addQuote: data =>
    https
      .post('meter/v1/contract/add_quote', JSON.stringify(data))
      .then(res => res),

  addContractRegister: data =>
    https
      .post('meter/v1/contract/add_contract_register', JSON.stringify(data))
      .then(res => res),

  passContractReview: data =>
    http.post('meter/v1/contract/pass_contract_review', data).then(res => res),

  contractReviewBack: data =>
    http.post('meter/v1/contract/contract_review_back', data).then(res => res),

  getReviewById: data =>
    http.get('meter/v1/contract/review/' + data).then(res => res),
  getReviewRecordById: data =>
    http.get('meter/v1/contract/review_record/' + data).then(res => res)
}
