/**
 * 工作台
 */

import http from '../http'
import { https } from '../https'

export default {
  // page
  page: data => http.post('meter/v1/entrust/page', data).then(res => res),
  // list
  pageList: data => http.get('res/v1/customer/list').then(res => res),

  // querylist
  pageQueryList: data =>
    http.get('/res/v1/customer/list?cname=' + data).then(res => res),
  pageSendEntrust: data =>
    http
      .post('meter/v1/entrust/page_send_draft_entrust', data)
      .then(res => res),
  pageSendEntrustHis: data =>
    http
      .post('meter/v1/entrust/page_send_draft_entrust_his', data)
      .then(res => res),

  pageDistributeEntrust: data =>
    http
      .post('meter/v1/entrust/page_distribute_entrust', data)
      .then(res => res),

  pageGoOutEntrust: data =>
    http.post('meter/v1/entrust/page_out_draft_entrust', data).then(res => res),
  pageClientOnlineEntrust: data =>
    http
      .post('meter/v1/entrust/page_client_online_entrust', data)
      .then(res => res),
  pageGoOutEntrustHis: data =>
    http
      .post('meter/v1/entrust/page_out_draft_entrust_his', data)
      .then(res => res),
  pageOutTaskDistribute: data =>
    http
      .post('meter/v1/entrust/page_out_task_distribute', data)
      .then(res => res),
  pageEntrustReview: data =>
    http.post('meter/v1/entrust/page_review_entrust', data).then(res => res),
  pageEntrustReceive: data =>
    http
      .post('meter/v1/entrust/page_sample_receive_entrust', data)
      .then(res => res),
  pageSubpackageEntrust: data =>
    http
      .post('meter/v1/entrust/page_subpackage_entrust', data)
      .then(res => res),
  pageSubpackageEntrustHis: data =>
    http
      .post('meter/v1/entrust/page_subpackage_entrust_his', data)
      .then(res => res),
  // 委托评审驳回
  back: data =>
    http
      .post(
        'meter/v1/entrust/review_back?ids=' +
          data.ids +
          '&reason=' +
          data.remark
      )
      .then(res => res),
  pageSubpackageInputEntrust: data =>
    http
      .post('meter/v1/entrust/page_subpackage_input_entrust', data)
      .then(res => res),
  // 操作日志
  pageOutTaskOperation: data =>
    http.post('meter/v1/entrust_record/page', data).then(res => res),
  getById: data => http.get('meter/v1/entrust/' + data).then(res => res),
  getVOById: data => http.get('meter/v1/entrust/vo/' + data).then(res => res),
  deleteById: data =>
    http.delete('meter/v1/entrust/?ids=' + data).then(res => res),
  // 保存
  save: data =>
    https
      .post('meter/v1/entrust/add_send_entrust', JSON.stringify(data))
      .then(res => res),
  saveOutEntrust: data =>
    https
      .post('meter/v1/entrust/add_out_entrust', JSON.stringify(data))
      .then(res => res),
  editDTO: data =>
    https
      .post('meter/v1/entrust/edit_entrust', JSON.stringify(data))
      .then(res => res),
  // 提交
  submit: data =>
    https
      .post('meter/v1/entrust/submit_to_review?ids=' + data)
      .then(res => res),
  submitToEntrustRegister: data =>
    https
      .post('meter/v1/entrust/submit_to_entrust_register?ids=' + data)
      .then(res => res),

  passReview: data =>
    http.post('meter/v1/entrust/pass_review?ids=' + data).then(res => res),

  // 编辑
  edit: data =>
    http.put('meter/v1/entrust/' + data.id, data.obj).then(res => res),
  // 省份
  getProvince: data => http.post('/base/v1/province/list_all').then(res => res),
  // 城市
  getCity: data => http.post('/base/v1/city/list_' + data).then(res => res),
  // 地区
  getArea: data => http.post('/base/v1/area/list_' + data).then(res => res)
}
