/**
 * 工作台
 */

import http from '../http'
import { https } from '../https'

export default {
  // page
  page: data => http.post('meter/v1/sample/page', data).then(res => res),
  pageSampleProgress: data =>
    http.post('meter/v1/sample/page_sample_progress', data).then(res => res),

  pageSampleReceive: data =>
    http.post('meter/v1/sample/page_sample_receive', data).then(res => res),

  pageSampleDistribute: data =>
    http.post('meter/v1/sample/page_sample_distribute', data).then(res => res),

  pageSampleFlow: data =>
    http.post('meter/v1/sample/page_sample_flow', data).then(res => res),

  // 报告模板
  pageReport: data =>
    http.post('/base/v1/file_template/page', data).then(res => res),
  // 车辆管理
  pageCarManage: data =>
    http.post('/res/v1/car_info/page_car_manage', data).then(res => res),
  pageCarList: data =>
    http.post('meter/v1/test_car/page', data).then(res => res),
  // 仪器列表
  pageInstrutEdit: data =>
    http.post('meter/v1/test_device/page', data).then(res => res),
  pageSubpackageSample: data =>
    http.post('meter/v1/sample/page_subpackage_sample', data).then(res => res),
  pageSubpackageSampleQuery: data =>
    http
      .post('meter/v1/sample/page_subpackage_sample_query', data)
      .then(res => res),
  pageSubpackageSampleInput: data =>
    http
      .post('meter/v1/sample/page_subpackage_sample_input', data)
      .then(res => res),
  pageOutDistribute: data =>
    http.post('meter/v1/sample/page_distribute', data).then(res => res),
  pageOutPersonalTask: data =>
    http.post('meter/v1/sample/page_out_personal_task', data).then(res => res),

  pageSampleInput: data =>
    http.post('meter/v1/sample/page_sample_input', data).then(res => res),

  pageSampleInStock: data =>
    http.post('meter/v1/sample/page_sample_in_stock', data).then(res => res),
  pageSampleInStockHis: data =>
    http
      .post('meter/v1/sample/page_sample_in_stock_his', data)
      .then(res => res),

  pageSampleOutStock: data =>
    http.post('meter/v1/sample/page_sample_out_stock', data).then(res => res),
  pageSampleOutStockHis: data =>
    http
      .post('meter/v1/sample/page_sample_out_stock_his', data)
      .then(res => res),

  pageCertificateMake: data =>
    http.post('meter/v1/sample/page_certificate_make', data).then(res => res),
  pageCertificateCheck: data =>
    http.post('meter/v1/sample/page_certificate_check', data).then(res => res),
  pageCertificateIssue: data =>
    http.post('meter/v1/sample/page_certificate_issue', data).then(res => res),
  getById: data => http.get('meter/v1/sample/' + data).then(res => res),
  reportPreview: data =>
    http
      .post('meter/v1/sample/report_preview_login?id=' + data)
      .then(res => res),
  deleteById: data =>
    http.delete('meter/v1/sample/?ids=' + data).then(res => res),
  // 保存
  save: data =>
    https
      .post('meter/v1/sample/add_send_entrust', JSON.stringify(data))
      .then(res => res),
  addSample: data => http.post('meter/v1/sample/', data).then(res => res),
  chaseAddSample: data =>
    http.post('meter/v1/sample/chase_add_sample', data).then(res => res),
  saveSampleEnv: data =>
    http
      .put('meter/v1/sample/save_sample_env/' + data.ids, data.obj)
      .then(res => res),
  // 取消分包
  subpackageCancel: data =>
    http
      .post('meter/v1/sample/subpackage_cancel_sample?ids=' + data.ids)
      .then(res => res),
  subpackageSample: data =>
    http.post('meter/v1/sample/subpackage_sample?ids=' + data).then(res => res),

  submitReportToCheck: data =>
    http
      .post('meter/v1/sample/submit_report_to_check?ids=' + data)
      .then(res => res),
  submitReportToIssue: data =>
    http
      .post('meter/v1/sample/submit_report_to_issue?ids=' + data)
      .then(res => res),
  submitReportToEnd: data =>
    http
      .post('meter/v1/sample/submit_report_to_end?ids=' + data)
      .then(res => res),
  submitFlow: data =>
    https
      .post('meter/v1/sample/sample_flow', JSON.stringify(data))
      .then(res => res),

  generateReport: data =>
    https
      .post('meter/v1/sample/report_generate', JSON.stringify(data))
      .then(res => res),

  subpackageInfoReg: data =>
    http
      .post('meter/v1/sample/subpackage_info_reg?ids=' + data.ids, data.reg)
      .then(res => res),

  subpackageOutStock: data =>
    http
      .post('meter/v1/sample/subpackage_out_stock?ids=' + data.ids, data.obj)
      .then(res => res),

  sampleInStock: data =>
    http
      .put('meter/v1/sample/sample_in_stock/' + data.ids, data.obj)
      .then(res => res),

  sampleOutStock: data =>
    http
      .put('meter/v1/sample/sample_out_stock/' + data.ids, data.obj)
      .then(res => res),

  subpackageInStock: data =>
    http
      .post('meter/v1/sample/subpackage_in_stock?ids=' + data.ids, data.obj)
      .then(res => res),

  submitReceive: data =>
    http.post('meter/v1/sample/submit_receive?ids=' + data).then(res => res),

  taskTransfer: data =>
    http
      .post(
        'meter/v1/sample/task_transfer?ids=' +
          data.ids +
          '&user=' +
          data.user +
          '&userId=' +
          data.userId
      )
      .then(res => res),

  reportCheckBack: data =>
    http
      .post(
        'meter/v1/sample/report_check_back?ids=' +
          data.ids +
          '&reason=' +
          data.reason
      )
      .then(res => res),

  distributeOutSample: data =>
    http
      .post(
        'meter/v1/sample/out_task_distribute?ids=' +
          data.ids +
          '&userId=' +
          data.userId +
          '&user=' +
          data.user
      )
      .then(res => res),

  sendTaskDistribute: data =>
    http
      .post(
        'meter/v1/sample/send_task_distribute?ids=' +
          data.ids +
          '&userId=' +
          data.userId +
          '&user=' +
          data.user
      )
      .then(res => res)
}
