/**
 * 工作台
 */

import http from '../http'
import { https } from '../https'

export default {
  // page
  page: data => http.post('soil/v1/entrust/page', data).then(res => res),
  pageRegHis: data =>
    http.post('soil/v1/entrust/page_reg_his', data).then(res => res),
  pageItem: data => http.post('soil/v1/experiment/page', data).then(res => res),
  pageItemByEntrustId: data =>
    http.post('soil/v1/experiment/page_by_entrust', data).then(res => res),
  openSoilRecord: data =>
    http.post('soil/v1/open_soil_record/page', data).then(res => res),
  getRecordById: data =>
    http.get('soil/v1/open_soil_record/' + data).then(res => res),
  listEntrustItemNum: data =>
    http
      .post('soil/v1/statistics/list_entrust_item_num', data)
      .then(res => res),
  pageReview: data =>
    http.post('soil/v1/entrust/page_review', data).then(res => res),
  pageSampleReceive: data =>
    http.post('soil/v1/entrust/page_sample_receive', data).then(res => res),
  pageAloneKeep: data =>
    http.post('soil/v1/entrust/page_alone_keep', data).then(res => res),
  pageLocationEntrust: data =>
    http
      .post('soil/v1/entrust/page_receive_location_entrust', data)
      .then(res => res),
  pageSampleTake: data =>
    http.post('soil/v1/entrust/page_sample_take', data).then(res => res),
  pageSampleReceiveHis: data =>
    http.post('soil/v1/entrust/page_sample_receive_his', data).then(res => res),
  pageSamplePrepare: data =>
    http.post('soil/v1/entrust/page_sample_prepare', data).then(res => res),
  pageSamplePrepareCheck: data =>
    http
      .post('soil/v1/entrust/page_sample_prepare_check', data)
      .then(res => res),
  pageSamplePrepareHis: data =>
    http.post('soil/v1/entrust/page_sample_prepare_his', data).then(res => res),
  pageSamplePrepareCheckHis: data =>
    http
      .post('soil/v1/entrust/page_sample_prepare_check_his', data)
      .then(res => res),
  getById: data => http.get('soil/v1/entrust/' + data).then(res => res),
  getVOById: data => http.get('soil/v1/entrust/vo/' + data).then(res => res),
  deleteById: data =>
    http.delete('soil/v1/entrust/?ids=' + data).then(res => res),
  standardAnnexDelete: data =>
    http.delete('soil/v1/standard_annex/?ids=' + data).then(res => res),
  experimentDeleteById: data =>
    http.delete('soil/v1/experiment/?ids=' + data).then(res => res),
  // 保存
  save: data =>
    https
      .post('soil/v1/entrust/add_entrust', JSON.stringify(data))
      .then(res => res),
  edit: data => http.put('soil/v1/entrust/' + data.id, data.obj),
  editDTO: data =>
    https
      .post('soil/v1/entrust/edit_entrust', JSON.stringify(data))
      .then(res => res),
  editItem: data => http.put('soil/v1/experiment/' + data.id, data.obj),
  submit: data =>
    https.post('soil/v1/entrust/submit_to_review?ids=' + data).then(res => res),
  submitSkipReview: data =>
    https
      .post('soil/v1/entrust/submit_to_skip_review?ids=' + data)
      .then(res => res),
  back: data =>
    http
      .post(
        'soil/v1/entrust/review_back?ids=' + data.ids + '&reason=' + data.remark
      )
      .then(res => res),
  reviewPass: data =>
    http.post('soil/v1/entrust/review_pass?ids=' + data).then(res => res),
  samplePage: data => http.post('soil/v1/sample/page', data).then(res => res),
  pageReceive: data =>
    http.post('soil/v1/sample/page_receive', data).then(res => res),
  pageReceiveHis: data =>
    http.post('soil/v1/sample/page_receive_his', data).then(res => res),
  pageAloneKeepSample: data =>
    http.post('soil/v1/sample/page_alone_keep_sample', data).then(res => res),
  pageSend: data =>
    http.post('soil/v1/sample/page_send', data).then(res => res),
  pageSendHis: data =>
    http.post('soil/v1/sample/page_send_his', data).then(res => res),
  receiveSample: data =>
    http.post('soil/v1/sample/receive_sample', data).then(res => res),
  sampleRetain: data =>
    http.post('soil/v1/sample/sample_retain', data).then(res => res),
  sendSample: data =>
    http.post('soil/v1/sample/send_sample', data).then(res => res),
  aloneKeepSample: data =>
    http.post('soil/v1/sample/alone_keep_sample', data).then(res => res),
  pagePrepare: data =>
    http.post('soil/v1/sample/page_prepare', data).then(res => res),
  pagePrepareCheck: data =>
    http.post('soil/v1/sample/page_prepare_check', data).then(res => res),
  pagePrepareHis: data =>
    http.post('soil/v1/sample/page_prepare_his', data).then(res => res),
  pagePrepareDetailHis: data =>
    http.post('soil/v1/prepare/page_prepare_detail', data).then(res => res),
  sampleEdit: data =>
    http.put(
      'soil/v1/sample/' + data.id + '?describeDetail=' + data.describeDetail
    ),
  sampleRemarkEdit: data =>
    http.put('soil/v1/sample/' + data.id + '?remark=' + data.remark),
  weiteSoilDetail: data =>
    http.post('soil/v1/sample/write_soil_detail', data).then(res => res),
  pageBackup: data =>
    http.post('soil/v1/sample_backup/page_backup', data).then(res => res),
  // 试验项目列表
  experimentPage: data =>
    http.post('soil/v1/experiment/page', data).then(res => res),
  // 开土制备试验照片预览
  photoView: data =>
    http
      .get('soil/v1/sample_photo/view?objectKey=' + data.objectKey)
      .then(res => res),
  // 试样制备表
  // preparePage: data =>
  //   http
  //     .post('soil/v1/sample/obtain_prepare_data?ids=' + data)
  //     .then(res => res),
  preparePage: data =>
    http.post('soil/v1/sample/obtain_prepare_data', data).then(res => res),

  // 试样制备完成
  savePrepare: data =>
    https
      .post('soil/v1/sample/prepare_ok', JSON.stringify(data))
      .then(res => res),
  // 试验室按样品分页列表
  pageTake: data =>
    http.post('soil/v1/sample/page_take', data).then(res => res),
  testType: data =>
    http.post('res/v1/dict/dict_query?type=' + data).then(res => res),
  projectQueryList: data =>
    http.post('res/v1/dict/dict_query', data).then(res => res),
  pageSurplusHandleCheckHis: data =>
    http
      .post('soil/v1/prepare/page_surplus_handle_check_his', data)
      .then(res => res),
  aloneSampleAdd: data =>
    http.post('soil/v1/alone_sample/', data).then(res => res),
  aloneSampleGetById: data =>
    http.get('soil/v1/alone_sample/' + data).then(res => res),
  getAloneVOById: data =>
    http.get('soil/v1/alone_sample/vo/' + data).then(res => res),
  aloneSampleEdit: data =>
    http.put('soil/v1/alone_sample/' + data.id, data).then(res => res),
  aloneSampleDelete: data =>
    http.delete('soil/v1/alone_sample/?ids=' + data).then(res => res),
  getUserByGroupId: data =>
    http.post('base/v1/user/page', data).then(res => res),
  submitToInstock: data =>
    http
      .post('soil/v1/alone_sample/submit_to_out_storage', data)
      .then(res => res),
  // 登记历史记录
  pageRegisterHis: data =>
    http.post('soil/v1/alone_sample/page_register_his', data).then(res => res),
  // 出库历史记录
  pageWaitDeliveryHis: data =>
    http
      .post('soil/v1/alone_sample/page_wait_delivery_his', data)
      .then(res => res),
  // 入库历史记录
  pageWaitStorageHis: data =>
    http
      .post('soil/v1/alone_sample/page_wait_storage_his', data)
      .then(res => res),
  bathChangeStorehouse: data =>
    http
      .post('soil/v1/alone_sample/bath_change_storehouse', data)
      .then(res => res),
  pageSampleOfStorehouse: data =>
    http
      .post('soil/v1/alone_sample/page_sample_of_storehouse', data)
      .then(res => res),
  callOutAloneKeepSample: data =>
    http
      .post('soil/v1/sample/call_out_alone_keep_sample/', data)
      .then(res => res),
  listSummaryQuery: data =>
    http.post('soil/v1/entrust/list_summary_query', data).then(res => res),
  getInExport: data =>
    http.get('soil/v1/alone_sample/get_in_export_' + data).then(res => res),
  getOutExport: data =>
    http.get('soil/v1/alone_sample/get_out_export_' + data).then(res => res)
}
