/**
 * 工作台
 */

import http from '../http'
// import { https } from '../https'

export default {
  // 检测依据管理
  standardPage: data =>
    http.post('soil/v1/standard/page', data).then(res => res),
  standardGetById: data =>
    http.get('soil/v1/standard/' + data).then(res => res),
  standardSave: data => http.post('soil/v1/standard/', data).then(res => res),
  standardEdit: data =>
    http.put('soil/v1/standard/' + data.id, data.obj).then(res => res),
  standardDeleteById: data =>
    http.delete('soil/v1/standard/?ids=' + data).then(res => res),
  // 试验项目
  // page
  page: data => http.post('soil/v1/aptitude_exp/page', data).then(res => res),
  getById: data => http.get('soil/v1/aptitude_exp/' + data).then(res => res),
  deleteById: data =>
    http.delete('soil/v1/aptitude_exp/?ids=' + data).then(res => res),
  // 保存
  save: data => http.post('soil/v1/aptitude_exp/', data).then(res => res),
  editSeniorSample: data =>
    http
      .post('soil/v1/sample/edit_senior_sample?ids=' + data.ids, data.obj)
      .then(res => res),
  edit: data =>
    http.put('soil/v1/aptitude_exp/' + data.id, data.obj).then(res => res),
  // 指标页面
  expItemPage: data =>
    http.post('soil/v1/exp_item/page', data).then(res => res),
  expItemDeleteByIds: data =>
    http.delete('soil/v1/exp_item/?ids=' + data).then(res => res),
  expItemSave: data => http.post('soil/v1/exp_item/', data).then(res => res),
  expItemEdit: data =>
    http.put('soil/v1/exp_item/' + data.id, data.obj).then(res => res),
  expItemGetById: data => http.get('soil/v1/exp_item/' + data).then(res => res),
  getStandardList: data =>
    http.post('soil/v1/standard/list', data).then(res => res),
  getGroupList: data =>
    http.post('/res/v1/user_group/list', data).then(res => res),
  getDictInfo: data => http.post('/res/v1/dict/page', data).then(res => res),
  getBasisList: data =>
    http.post('soil/v1/standard/list', data).then(res => res),
  originalTemplatePage: data =>
    http.post('soil/v1/original_template/page', data).then(res => res),
  pageOpenSoil: data =>
    http
      .post('soil/v1/original_template/page_open_soil', data)
      .then(res => res),
  pageInOutExportTemplate: data =>
    http
      .post('soil/v1/original_template/page_in_out_export_template', data)
      .then(res => res),
  originalTemplateDeleteById: data =>
    http.delete('soil/v1/original_template/?ids=' + data).then(res => res),
  originalTemplateEdit: data =>
    http
      .put('soil/v1/original_template/' + data.id, data.formObj)
      .then(res => res),
  originalTemplateGetById: data =>
    http.get('soil/v1/original_template/' + data).then(res => res),
  // 试验项目分页列表
  expReportTemplatePage: data =>
    http.post('soil/v1/exp_report_template/page', data).then(res => res),
  // 试验项目根据id查询信息
  expReportTemplateGetById: data =>
    http.get('soil/v1/exp_report_template/' + data).then(res => res),
  // 试验项目模板编辑
  expReportTemplateEdit: data =>
    http
      .put('soil/v1/exp_report_template/' + data.id, data.formObj)
      .then(res => res),
  expReportTemplateDelete: data =>
    http.delete('soil/v1/exp_report_template/?ids=' + data).then(res => res),
  pageTemplateConfig: data =>
    http.post('soil/v1/exp_report_template_config/page', data).then(res => res),
  saveReportTemplateConfig: data =>
    http.post('soil/v1/exp_report_template_config/', data).then(res => res),
  expReportTemplateConfigEdit: data =>
    http
      .put('soil/v1/exp_report_template_config/' + data.id, data.obj)
      .then(res => res),
  deleteReportTemplateConfig: data =>
    http
      .delete('soil/v1/exp_report_template_config/?ids=' + data)
      .then(res => res),
  originalTemplateConfig: data =>
    http.post('soil/v1/original_template_config/page', data).then(res => res),
  saveOriginalTemplateConfig: data =>
    http.post('soil/v1/original_template_config/', data).then(res => res),
  getOriginalTemplateConfig: data =>
    http.get('soil/v1/original_template_config/' + data).then(res => res),
  editOriginalTemplateConfig: data =>
    http
      .put('soil/v1/original_template_config/' + data.id, data.obj)
      .then(res => res),
  deleteOriginalTemplateConfig: data =>
    http
      .delete('soil/v1/original_template_config/?ids=' + data)
      .then(res => res),
  expReportTemplateConfig: data =>
    http.get('soil/v1/exp_report_template_config/' + data).then(res => res),
  // 汇总表分页列表
  pageSummaryTemplate: data =>
    http
      .post('soil/v1/exp_report_template/page_summary_template', data)
      .then(res => res),
  originalTemplateBalance: data =>
    http.post('soil/v1/original_template_balance/page', data).then(res => res),
  originalTemplateBalanceSave: data =>
    http.post('soil/v1/original_template_balance/', data).then(res => res),
  originalTemplateBalanceGet: data =>
    http.get('soil/v1/original_template_balance/' + data).then(res => res),
  originalTemplateBalanceEdit: data =>
    http
      .put('soil/v1/original_template_balance/' + data.id, data.obj)
      .then(res => res),
  originalTemplateBalanceDelete: data =>
    http
      .delete('soil/v1/original_template_balance/?ids=' + data)
      .then(res => res),
  soilEnvMonitorWarning: data =>
    http.post('soil/v1/env_monitor/page', data).then(res => res),
  envMonitorWarningPage: data =>
    http.post('soil/v1/env_monitor_warning/page', data).then(res => res),
  envMonitorWarningDelete: data =>
    http.delete('soil/v1/env_monitor/?ids=' + data).then(res => res),
  deleteEnvMonitorWarning: data =>
    http.delete('soil/v1/env_monitor_warning/?ids=' + data).then(res => res),
  envMonitorWarningInfo: data =>
    http.get('soil/v1/env_monitor/' + data.id).then(res => res),
  infoEnvMonitorWarning: data =>
    http.get('soil/v1/env_monitor_warning/' + data.id).then(res => res),
  envMonitorEdit: data =>
    http.put('soil/v1/env_monitor/' + data.id, data.obj).then(res => res),
  editEnvMonitor: data =>
    http
      .put('soil/v1/env_monitor_warning/' + data.id, data.obj)
      .then(res => res),
  envMonitorAdd: data =>
    http.post('soil/v1/env_monitor/', data).then(res => res),
  addEnvMonitor: data =>
    http.post('soil/v1/env_monitor_warning/', data).then(res => res)
}
