import Vue from 'vue'
import Meta from 'vue-meta'
import ClientOnly from 'vue-client-only'
import NoSsr from 'vue-no-ssr'
import { createRouter } from './router.js'
import NuxtChild from './components/nuxt-child.js'
import NuxtError from './components/nuxt-error.vue'
import Nuxt from './components/nuxt.js'
import App from './App.js'
import { setContext, getLocation, getRouteData, normalizeError } from './utils'
import { createStore } from './store.js'

/* Plugins */

import nuxt_plugin_cookieuniversalnuxt_b51960e4 from 'nuxt_plugin_cookieuniversalnuxt_b51960e4' // Source: .\\cookie-universal-nuxt.js (mode: 'all')
import nuxt_plugin_router_34e1cc89 from 'nuxt_plugin_router_34e1cc89' // Source: .\\router.js (mode: 'all')
import nuxt_plugin_axios_35b23be6 from 'nuxt_plugin_axios_35b23be6' // Source: .\\axios.js (mode: 'all')
import nuxt_plugin_iview_acf623c2 from 'nuxt_plugin_iview_acf623c2' // Source: ..\\plugins\\iview.js (mode: 'all')
import nuxt_plugin_elementui_72a9ed1c from 'nuxt_plugin_elementui_72a9ed1c' // Source: ..\\plugins\\element-ui.js (mode: 'all')
import nuxt_plugin_common_17412d76 from 'nuxt_plugin_common_17412d76' // Source: ..\\plugins\\common.js (mode: 'all')
import nuxt_plugin_drag_58cd440d from 'nuxt_plugin_drag_58cd440d' // Source: ..\\plugins\\drag.js (mode: 'all')
import nuxt_plugin_global_f21f4e84 from 'nuxt_plugin_global_f21f4e84' // Source: ..\\plugins\\global.js (mode: 'all')
import nuxt_plugin_editor_0177eeb4 from 'nuxt_plugin_editor_0177eeb4' // Source: ..\\plugins\\editor.js (mode: 'client')
import nuxt_plugin_gallery_80c8034e from 'nuxt_plugin_gallery_80c8034e' // Source: ..\\plugins\\gallery.js (mode: 'client')
import nuxt_plugin_ieCharts_06d0d55c from 'nuxt_plugin_ieCharts_06d0d55c' // Source: ..\\plugins\\ieCharts.js (mode: 'client')

// Component: <ClientOnly>
Vue.component(ClientOnly.name, ClientOnly)

// TODO: Remove in Nuxt 3: <NoSsr>
Vue.component(NoSsr.name, {
  ...NoSsr,
  render (h, ctx) {
    if (process.client && !NoSsr._warned) {
      NoSsr._warned = true

      console.warn(`<no-ssr> has been deprecated and will be removed in Nuxt 3, please use <client-only> instead`)
    }
    return NoSsr.render(h, ctx)
  }
})

// Component: <NuxtChild>
Vue.component(NuxtChild.name, NuxtChild)
Vue.component('NChild', NuxtChild)

// Component NuxtLink is imported in server.js or client.js

// Component: <Nuxt>`
Vue.component(Nuxt.name, Nuxt)

Vue.use(Meta, {"keyName":"head","attribute":"data-n-head","ssrAttribute":"data-n-head-ssr","tagIDKeyName":"hid"})

const defaultTransition = {"name":"page","mode":"out-in","appear":false,"appearClass":"appear","appearActiveClass":"appear-active","appearToClass":"appear-to"}

async function createApp (ssrContext) {
  const router = await createRouter(ssrContext)

  const store = createStore(ssrContext)
  // Add this.$router into store actions/mutations
  store.$router = router

  // Fix SSR caveat https://github.com/nuxt/nuxt.js/issues/3757#issuecomment-414689141
  const registerModule = store.registerModule
  store.registerModule = (path, rawModule, options) => registerModule.call(store, path, rawModule, Object.assign({ preserveState: process.client }, options))

  // Create Root instance

  // here we inject the router and store to all child components,
  // making them available everywhere as `this.$router` and `this.$store`.
  const app = {
    store,
    router,
    nuxt: {
      defaultTransition,
      transitions: [ defaultTransition ],
      setTransitions (transitions) {
        if (!Array.isArray(transitions)) {
          transitions = [ transitions ]
        }
        transitions = transitions.map((transition) => {
          if (!transition) {
            transition = defaultTransition
          } else if (typeof transition === 'string') {
            transition = Object.assign({}, defaultTransition, { name: transition })
          } else {
            transition = Object.assign({}, defaultTransition, transition)
          }
          return transition
        })
        this.$options.nuxt.transitions = transitions
        return transitions
      },

      err: null,
      dateErr: null,
      error (err) {
        err = err || null
        app.context._errored = Boolean(err)
        err = err ? normalizeError(err) : null
        const nuxt = this.nuxt || this.$options.nuxt
        nuxt.dateErr = Date.now()
        nuxt.err = err
        // Used in src/server.js
        if (ssrContext) {
          ssrContext.nuxt.error = err
        }
        return err
      }
    },
    ...App
  }

  // Make app available into store via this.app
  store.app = app

  const next = ssrContext ? ssrContext.next : location => app.router.push(location)
  // Resolve route
  let route
  if (ssrContext) {
    route = router.resolve(ssrContext.url).route
  } else {
    const path = getLocation(router.options.base)
    route = router.resolve(path).route
  }

  // Set context to app.context
  await setContext(app, {
    store,
    route,
    next,
    error: app.nuxt.error.bind(app),
    payload: ssrContext ? ssrContext.payload : undefined,
    req: ssrContext ? ssrContext.req : undefined,
    res: ssrContext ? ssrContext.res : undefined,
    beforeRenderFns: ssrContext ? ssrContext.beforeRenderFns : undefined,
    ssrContext
  })

  const inject = function (key, value) {
    if (!key) {
      throw new Error('inject(key, value) has no key provided')
    }
    if (value === undefined) {
      throw new Error('inject(key, value) has no value provided')
    }

    key = '$' + key
    // Add into app
    app[key] = value

    // Add into store
    store[key] = app[key]

    // Check if plugin not already installed
    const installKey = '__nuxt_' + key + '_installed__'
    if (Vue[installKey]) {
      return
    }
    Vue[installKey] = true
    // Call Vue.use() to install the plugin into vm
    Vue.use(() => {
      if (!Vue.prototype.hasOwnProperty(key)) {
        Object.defineProperty(Vue.prototype, key, {
          get () {
            return this.$root.$options[key]
          }
        })
      }
    })
  }

  if (process.client) {
    // Replace store state before plugins execution
    if (window.__NUXT__ && window.__NUXT__.state) {
      store.replaceState(window.__NUXT__.state)
    }
  }

  // Plugin execution

  if (typeof nuxt_plugin_cookieuniversalnuxt_b51960e4 === 'function') {
    await nuxt_plugin_cookieuniversalnuxt_b51960e4(app.context, inject)
  }

  if (typeof nuxt_plugin_router_34e1cc89 === 'function') {
    await nuxt_plugin_router_34e1cc89(app.context, inject)
  }

  if (typeof nuxt_plugin_axios_35b23be6 === 'function') {
    await nuxt_plugin_axios_35b23be6(app.context, inject)
  }

  if (typeof nuxt_plugin_iview_acf623c2 === 'function') {
    await nuxt_plugin_iview_acf623c2(app.context, inject)
  }

  if (typeof nuxt_plugin_elementui_72a9ed1c === 'function') {
    await nuxt_plugin_elementui_72a9ed1c(app.context, inject)
  }

  if (typeof nuxt_plugin_common_17412d76 === 'function') {
    await nuxt_plugin_common_17412d76(app.context, inject)
  }

  if (typeof nuxt_plugin_drag_58cd440d === 'function') {
    await nuxt_plugin_drag_58cd440d(app.context, inject)
  }

  if (typeof nuxt_plugin_global_f21f4e84 === 'function') {
    await nuxt_plugin_global_f21f4e84(app.context, inject)
  }

  if (process.client && typeof nuxt_plugin_editor_0177eeb4 === 'function') {
    await nuxt_plugin_editor_0177eeb4(app.context, inject)
  }

  if (process.client && typeof nuxt_plugin_gallery_80c8034e === 'function') {
    await nuxt_plugin_gallery_80c8034e(app.context, inject)
  }

  if (process.client && typeof nuxt_plugin_ieCharts_06d0d55c === 'function') {
    await nuxt_plugin_ieCharts_06d0d55c(app.context, inject)
  }

  // If server-side, wait for async component to be resolved first
  if (process.server && ssrContext && ssrContext.url) {
    await new Promise((resolve, reject) => {
      router.push(ssrContext.url, resolve, () => {
        // navigated to a different route in router guard
        const unregister = router.afterEach(async (to, from, next) => {
          ssrContext.url = to.fullPath
          app.context.route = await getRouteData(to)
          app.context.params = to.params || {}
          app.context.query = to.query || {}
          unregister()
          resolve()
        })
      })
    })
  }

  return {
    store,
    app,
    router
  }
}

export { createApp, NuxtError }
