/**
 * 计量系统平台路由
 */
// 工作台
import workbench from '../pages/workbench/workbench'
import StandardManage from '../pages/meter-aptitude/standard-manage/StandardManage'
import ExperimentItemManage from '../pages/meter-aptitude/item-manage/ExperimentItemManage'
import EntrustIndex from '../pages/meter-entrust/entrust-register/EntrustIndex'
import ReviewEntrust from '../pages/meter-entrust/entrust-review/ReviewEntrust'
import SampleReceiveIndex from '../pages/soil-sample-manage/sample-receive/SampleReceiveIndex'
import SamplePreparationIndex from '../pages/soil-sample-manage/sample-preparation/SamplePreparationIndex'
import AddressManage from '../pages/soil-sample-manage/sample-address/AddressManage'
import BackupsManage from '../pages/soil-sample-manage/backups-manage/SampleBackupsIndex'
import Blank from '~/pages/blank'
export default [
  {
    path: 'workbench',
    component: workbench,
    meta: { title: '首页' }
  },
  {
    path: 'entrust',
    component: Blank,
    children: [
      {
        path: 'entrust_register',
        component: EntrustIndex,
        meta: { title: '试验委托登记' }
      },
      {
        path: 'review',
        component: ReviewEntrust,
        meta: { title: '试验委托评审' }
      }
    ]
  },
  {
    path: 'sample',
    component: Blank,
    children: [
      {
        path: 'receive',
        component: SampleReceiveIndex,
        meta: { title: '收样室收样' }
      },
      {
        path: 'prepare',
        component: SamplePreparationIndex,
        meta: { title: '开土制备' }
      },
      {
        path: 'take',
        component: workbench,
        meta: { title: '试验室领样' }
      },
      {
        path: 'backups',
        component: BackupsManage,
        meta: { title: '备样管理' }
      },
      {
        path: 'receive_location',
        component: AddressManage,
        meta: { title: '收样位置管理' }
      }
    ]
  },
  {
    path: 'aptitude',
    component: Blank,
    children: [
      {
        path: 'test_basis',
        component: StandardManage,
        meta: { title: '检测依据管理' }
      },
      {
        path: 'experiment',
        component: ExperimentItemManage,
        meta: { title: '试验项目' }
      }
    ]
  }
]
