/**
 * 工作台
 */

import http from '../http'
import { https } from '../https'

export default {
  // page
  page: data => http.post('meter/v1/item/page', data).then(res => res),
  pageTest: data => http.post('meter/v1/item/page_test', data).then(res => res),
  // 个人任务
  getById: data => http.get('meter/v1/item/' + data).then(res => res),
  deleteById: data =>
    http.delete('meter/v1/item/?ids=' + data).then(res => res),
  // 保存
  save: data =>
    https
      .post('meter/v1/item/add_send_entrust', JSON.stringify(data))
      .then(res => res),
  saveItems: data =>
    http
      .post(
        'meter/v1/item/add_sample_item?sampleIds=' +
          data.sampleIds +
          '&itemIds=' +
          data.itemIds
      )
      .then(res => res),

  testValue: data =>
    http
      .post(
        'meter/v1/item/bath_write_value/' +
          data.itemIds +
          '?testValue=' +
          data.testValue
      )
      .then(res => res),
  _handJudge: data =>
    http.post('meter/v1/item/hand_judge/' + data.ids, data).then(res => res),

  testEnd: data =>
    http
      .post(
        'meter/v1/item/bath_test_end?itemIds=' +
          data.ids +
          '&sampleId=' +
          data.sampleId
      )
      .then(res => res)
}
