const Iframe = {
  // modal 框的 id
  modalId: '',

  // 默认最大化
  isMax: true,

  // 创建弹出框并弹出
  iframe: function(url, params, options) {
    const currentObj = this
    const windowWidth = $(window).width()
    const windowHeight = $(window).height()

    // 加一个遮罩层
    // let div = document.createElement('div');
    // div.style.width = '100%';
    // div.style.height = '100%';
    // div.style.backgroundColor = 'rgba(0, 0, 0, 0.2)';
    // div.style.zIndex = '999';
    // div.style.position = 'fixed';
    // div.style.top = '0';
    // div.style.left = '0';
    // div.className = 'record-modal-div';
    // document.body.appendChild(div);

    const modalId = 'modal-' + new Date().getTime()
    // 首先创建框架的 div 等视觉元素
    const modalDiv = document.createElement('div')
    // 创建loading div
    const loadingDiv = document.createElement('div')
    const loadingIcon = document.createElement('i')
    const loadingText = document.createElement('span')
    loadingDiv.className = 'record-loading-content'
    loadingIcon.className = 'ivu-icon ivu-icon-load-c demo-spin-icon-load'
    loadingText.innerText = '加载中，请稍后...'

    loadingDiv.appendChild(loadingIcon)
    loadingDiv.appendChild(loadingText)

    modalDiv.id = modalId
    modalDiv.className = 'record-modal'
    // 设置属性
    $(modalDiv).css({
      'z-index': '3000',
      left: '0',
      top: '0',
      height: windowHeight,
      width: windowWidth
    })
    // 设置loading的样式
    // $(loadingDiv).css({
    //   // 'left': (windowWidth - 800) / 2,
    //   // 'top': (windowHeight - 500) / 3,
    //   'height': '100%',
    //   'width': '100%',
    // });
    // 放入 document 中
    document.body.appendChild(modalDiv)

    // $(modalDiv).draggable()

    // modalDiv 创建标题栏
    const modalHeaderDiv = document.createElement('div')
    modalHeaderDiv.className = 'record-modal-header'
    modalDiv.appendChild(modalHeaderDiv)
    // 左边的title
    const modalTitleDiv = document.createElement('div')
    modalTitleDiv.className = 'record-modal-title'
    modalHeaderDiv.appendChild(modalTitleDiv)
    modalTitleDiv.innerText = '原始记录模板'

    // 标题栏中有按钮
    const modalBtnDiv = document.createElement('div')
    modalBtnDiv.className = 'record-modal-btn'
    modalHeaderDiv.appendChild(modalBtnDiv)
    // 里面三个按钮
    const minBtn = document.createElement('div')
    const maxBtn = document.createElement('div')
    const closeBtn = document.createElement('div')
    // 图标
    const minIcon = document.createElement('i')
    const maxIcon = document.createElement('i')
    const colseIcon = document.createElement('i')
    // — □ x
    minBtn.className = 'record-modal-min'
    minBtn.title = '最小化'
    minBtn.innerText = '—'
    modalBtnDiv.appendChild(minBtn)
    // minIcon.className = 'ivu-icon ios-bookmarks'
    minBtn.appendChild(minIcon)

    maxBtn.className = 'record-modal-max'
    maxBtn.title = '最大化'
    // maxBtn.innerText = '□';
    modalBtnDiv.appendChild(maxBtn)
    maxIcon.className = 'ivu-icon ivu-icon-ios-browsers-outline'
    maxBtn.appendChild(maxIcon)

    closeBtn.className = 'record-modal-close'
    closeBtn.title = '关闭'
    closeBtn.innerText = '×'
    // colseIcon.className = 'ivu-icon ivu-icon-ios-close-empty'
    closeBtn.appendChild(colseIcon)

    closeBtn.addEventListener('click', function closeBtnClickFunc() {
      currentObj.closeModalDiv()
    })
    modalBtnDiv.appendChild(closeBtn)

    // 创建 content 内容的 div
    const contentDiv = document.createElement('div')
    contentDiv.className = 'record-modal-content'
    contentDiv.id = 'record-modal-content'
    $(contentDiv).css({
      height: windowHeight - 30 + 'px'
    })
    modalDiv.appendChild(contentDiv)

    // 开始渲染 iframe 了
    // 动态创建并绑定URL
    const name = 'iframeName'

    // 创建 iframe
    const iframeElement = document.createElement('iframe')
    iframeElement.name = name
    iframeElement.style.width = '100%'
    iframeElement.style.height = '100%'
    iframeElement.style.display = 'none'
    iframeElement.scrolling = 'no'
    iframeElement.frameBorder = '0'

    contentDiv.appendChild(iframeElement)
    // loading事件
    contentDiv.appendChild(loadingDiv)

    // 创建 form
    const formElement = document.createElement('form')
    formElement.action = url
    formElement.target = name
    // 表单的方法提交
    formElement.method = 'GET'
    formElement.style.display = 'none'
    contentDiv.appendChild(formElement)

    // 创建表单需要提交的数据
    if (params !== undefined && params !== '{}') {
      for (const key in params) {
        const formInput = document.createElement('input')
        formInput.setAttribute('type', 'hidden')
        formInput.name = key
        formInput.value = params[key]
        formElement.appendChild(formInput)
      }
    }
    // 提交
    formElement.submit()

    // 各种事件

    // 点击最大化的事件
    $(maxBtn).bind('click', function(e) {
      currentObj.maxAnimate(
        currentObj,
        modalDiv,
        windowWidth,
        windowHeight,
        contentDiv,
        modalBtnDiv,
        maxBtn
      )
    })

    $(modalHeaderDiv).bind('dblclick', function() {
      currentObj.maxAnimate(
        currentObj,
        modalDiv,
        windowWidth,
        windowHeight,
        contentDiv,
        modalBtnDiv,
        maxBtn
      )
    })

    // 最小化事件
    $(minBtn).bind('click', function() {
      // 将 modal 隐藏, 并在左下角显示一个小框
      $(modalDiv).css('display', 'none')

      // 左下角创建小框
      const littleModal = document.createElement('div')
      $(littleModal).css({
        width: '300px',
        height: '30px',
        position: 'fixed',
        left: '100px',
        bottom: '100px',
        border: '1px solid #0079fd',
        'background-color': '#ffffff',
        'box-shadow': '0px 0px 10px #000000',
        'z-index': '3000'
      })
      document.body.appendChild(littleModal)

      // 存放标题
      const littleTitleDiv = document.createElement('div')
      $(littleTitleDiv).css({
        width: '220px',
        float: 'left',
        'line-height': '30px',
        'padding-left': '5px'
      })
      $(littleTitleDiv).text('原始记录模板')
      littleModal.appendChild(littleTitleDiv)

      // 存放按钮的 div
      const littleBtnDiv = document.createElement('div')
      littleBtnDiv.className = 'record-modal-btn'
      $(littleBtnDiv).css({
        width: '80px',
        float: 'left'
      })
      littleModal.appendChild(littleBtnDiv)

      // 两个按钮
      const littleMaxBtn = document.createElement('div')
      const littleCloseBtn = document.createElement('div')
      // □ x

      // littleMaxBtn.className = 'modal-max';
      // littleMaxBtn.innerText = '□';
      // littleBtnDiv.appendChild(littleMaxBtn);

      littleMaxBtn.className =
        'record-modal-max ivu-icon ivu-icon-ios-browsers-outline'
      littleBtnDiv.appendChild(littleMaxBtn)

      // littleCloseBtn.className = 'modal-close';
      littleCloseBtn.className =
        'record-modal-close ivu-icon ivu-icon-ios-close-empty'
      littleBtnDiv.appendChild(littleCloseBtn)
      // littleCloseBtn.innerText = '×';
      // littleBtnDiv.appendChild(littleCloseBtn);
      $(littleCloseBtn).bind('click', function() {
        // 销毁小窗口
        littleModal.remove()
        // 销毁大窗口, 虽然隐形了, 但是还是要销毁
        modalDiv.remove()
      })
      //
      $(littleMaxBtn).bind('click', function() {
        // 大窗口显示
        $(modalDiv).css('display', 'block')
        // 小窗口销毁
        littleModal.remove()
      })
    })
    // 给iframe绑定load时间监听渲染完毕
    $(iframeElement).bind('load', function() {
      $(loadingDiv).css('display', 'none')
      $(modalDiv).css('display', 'block')
      $(modalTitleDiv).text('原始记录模板')
      $(iframeElement).css('display', 'block')
    })
    window.onresize = function() {
      const newHeight = $(window).height()
      if (newHeight >= windowHeight) {
        $(modalDiv).css({
          height: newHeight
        })
        contentDiv.style.height = newHeight - 30 + 'px'
      }
    }
  },

  closeModalDiv: function() {
    const es = document.getElementsByClassName('record-modal')
    const length = es.length
    for (let i = 0; i < length; i++) {
      const e = es[i]
      e.remove()
    }
  },

  maxAnimate: function(
    currentObj,
    modalDiv,
    windowWidth,
    windowHeight,
    contentDiv,
    modalBtnDiv,
    maxBtn
  ) {
    if (currentObj.isMax) {
      // 此时应该还原, 但是如果拖动了的话, 需要重置为最大化
      if ($(modalDiv).offset().top !== 0 || $(modalDiv).offset().left !== 0) {
        $(modalDiv).css({
          top: '0',
          left: '0'
        })
        return false
      }

      // 如果已经最大化了, 点击按钮就是还原
      $(modalDiv).css({
        left: (windowWidth - 800) / 2,
        top: (windowHeight - 500) / 3,
        width: '800px',
        height: '500px'
      })
      // 重置 content 的高度
      $(contentDiv).css('height', '470px')
      $(modalBtnDiv).css('margin-left', '680px')
      // 已经还原
      currentObj.isMax = false
      maxBtn.title = '最大化'
    } else {
      // 没有最大化窗口, 点击按钮就是最大化窗口
      // 获取 document 的大小
      $(modalDiv).css({
        width: windowWidth + 'px',
        height: windowHeight + 'px',
        margin: '0',
        top: '0',
        left: '0'
      })
      // 重置 content 的高度
      $(contentDiv).css('height', windowHeight - 30 + 'px')
      // 按钮需要移到最右面
      $(modalBtnDiv).css('margin-left', windowWidth - 120 + 'px')
      // 已经最大化了
      currentObj.isMax = true
      maxBtn.title = '还原'
    }
  }
}

export { Iframe }
