import Vue from 'vue'
import Store from 'store2'
import extend from 'extend'
import dateformat from 'dateformat'
import serialize from 'form-serialize'
import string from 'string'
import FileSaver from 'file-saver'
import XLSX from 'xlsx'
import global from '../api/config'
/**
 *echart颜色
 *
 */

Vue.prototype.$echartColor = [
  '#00a0e9',
  '#CD5555',
  '#fa8e19',
  '#fad819',
  '#ff7f50',
  '#87cefa',
  '#da70d6',
  '#32cd32',
  '#6495ed',
  '#ff69b4',
  '#ba55d3',
  '#cd5c5c',
  '#ffa500',
  '#40e0d0',
  '#1e90ff',
  '#ff6347',
  '#7b68ee',
  '#00fa9a',
  '#ffd700',
  '#6699FF',
  '#ff6666',
  '#3cb371',
  '#b8860b',
  '#30e0e0'
]
/**
 * 字符串函数库
 * https://www.npmjs.com/package/string
 */
Vue.prototype.$string = string
/**
 * 日期格式化
 *  https://www.npmjs.com/package/dateformat
 */
Vue.prototype.$dateformat = dateformat
/**
 * 对象扩展
 * https://www.npmjs.com/package/extend
 */
Vue.prototype.$extend = extend
/**
 * 表单序列化
 *  https://www.npmjs.com/package/form-serialize
 */
// Vue.prototype.$serialize = function(formId) {
//   const form = document.querySelector('#' + formId)
//
//   // 通用方法去除输入框前后空格
//   $(document).ready(function() {
//     $('form').on('change', function() {
//       $('form input[type=text]').each(function() {
//         this.value = $.trim(this.value)
//       })
//     })
//   })
//
//   return serialize(form, { hash: true })
// }
Vue.prototype.$serialize = function(formId) {
  if (formId) {
    const form = document.querySelector('#' + formId)

    // 通用方法去除输入框前后空格
    $(document).ready(function() {
      $('form').on('change', function() {
        $('form input[type=text]').each(function() {
          this.value = $.trim(this.value)
        })
      })
    })

    return serialize(form, { hash: true })
  }
}
Vue.prototype.$serializeFormSearch = function(formObj) {
  const newFormObj = {}
  for (const key in formObj) {
    // 不为空的时候传值
    if (
      formObj[key] !== '' &&
      formObj[key] !== undefined &&
      formObj[key] !== null
    ) {
      if (typeof formObj[key] === 'string') {
        newFormObj[key] = formObj[key].trim() // 为字符串，则去掉前后空格
      } else {
        newFormObj[key] = formObj[key]
      }
    }
  }
  return newFormObj
}
/**
 *table默认展示多少条数据
 */
Vue.prototype.$pageParams = function() {
  return 50
}
/**
 *获取当前年月的最后一天
 */
Vue.prototype.$getLastDay = function(year, month) {
  let newYear = year // 取当前的年份
  let newMonth = month++ // 取下一个月的第一天，方便计算（最后一天不固定）
  if (month > 12) {
    // 如果当前大于12月，则年份转到下一年
    newMonth -= 12 // 月份减
    newYear++ // 年份增
  }
  const newDate = new Date(newYear, newMonth, 1) // 取当年当月中的第一天
  return new Date(newDate.getTime() - 1000 * 60 * 60 * 24).getDate() // 获取当月最后一天日期
}
/**
 *table默认展示切换list
 */
Vue.prototype.$pageSizeOpt = [20, 50, 100, 200]
Vue.prototype.$pageSizeOpts = function() {
  return [50, 100, 200, 300, 500]
}
/**
 * 面包屑
 */
Vue.prototype.$showBread = function(route) {
  const breadCrumbList = []
  for (let i = 0; i < route.matched.length; i++) {
    breadCrumbList.push(
      route.matched[i].meta ? route.matched[i].meta.title : ''
    )
  }
  return breadCrumbList
}
/**
 * table高度
 */
Vue.prototype.$tableHeight = function(name, cutHeight) {
  // 通过 process.browser 来区分环境
  if (process.browser) {
    let height = ''
    if (name) {
      switch (name) {
        // 有按钮和查询条件
        case 'search':
          height = document.documentElement.clientHeight - 255
          break
        // 有按钮和无查询条件
        case 'noSearch':
          height = document.documentElement.clientHeight - 210
          break
        // 有tab有按钮和有查询条件
        case 'tabSearch':
          height = document.documentElement.clientHeight - 300
          break
        // 有tab有按钮和有下拉条件有按钮
        case 'tabSelectSearch':
          height = document.documentElement.clientHeight - 315
          break
        // 有tab有按钮和无查询条件
        case 'tabNoSearch':
          height = document.documentElement.clientHeight - 260
          break
        // 有查询条件没有按钮
        case 'noBtn':
          height = document.documentElement.clientHeight - 240
          break
        // 有查询条件有tab没有按钮
        case 'tabNoBtn':
          height = document.documentElement.clientHeight - 275
          break
        // 有按钮和查询条件（两行查询条件）
        case 'searchTwo':
          height = document.documentElement.clientHeight - 300
          break
        // 无按钮，有查询条件（两行查询条件）
        case 'searchTwoNoBtn':
          height = document.documentElement.clientHeight - 300
          break
        // 有按钮、tab和查询条件（两行查询条件）
        case 'tabSearchTwo':
          height = document.documentElement.clientHeight - 375
          break
        // 弹出框中table高度（自适应屏幕高度）
        case 'tableModal':
          height = document.documentElement.clientHeight - 330
          break
        // table详情高度（自适应屏幕高度）
        case 'tableDetail':
          height = document.documentElement.clientHeight - 200 + 'px'
          break
        // 左侧树高度（自适应屏幕高度）
        case 'ztreeHeight':
          height = document.documentElement.clientHeight - 215 + 'px'
          break
        case 'ruleHeight':
          height = document.documentElement.clientHeight - 360
      }
    } else if (cutHeight !== undefined) {
      height = document.documentElement.clientHeight - cutHeight
    }
    return height
  }
}
/**
 * 按钮权限
 */
Vue.prototype.$showBtn = function(id) {
  if (id === '') {
    // 不添加权限
    return true
  }
  let result = false
  const list = Store.session('showBtnList')
    ? Store.session('showBtnList').split(',')
    : []
  const l = list.length
  if (l > 0) {
    // 添加权限
    for (let i = 0; i < l; i++) {
      if (list[i] === id) {
        result = true
      }
    }
  }
  return result
}
/**
 * 注：企业的table列重新分配以后，用户个性化（或自定义的表格列）将清空。☆
 * table columns 用户自定义
 * pageColumns ------ 本地数据
 * companyCodeList --- 获取企业的表格数据
 * userCodeList --- 获取用户的表格数据
 *
 */
Vue.prototype.$tableColumns = function(
  pageColumns,
  companyCodeList,
  userCodeList
) {
  // 企业table数据
  if (userCodeList.length === 0) {
    const companyResult = []
    for (let i = 0; i < pageColumns.length; i++) {
      companyCodeList.map(item => {
        if (item === pageColumns[i].key) {
          companyResult.push(pageColumns[i])
        }
      })
    }
    return companyCodeList
  }

  // 用户table数据
  const userResult = []
  for (let i = 0; i < pageColumns.length; i++) {
    userCodeList.map(item => {
      if (item === pageColumns[i].key) {
        userResult.push(pageColumns[i])
      }
    })
  }
  return userResult
}
/**
 * 验证固话
 */
Vue.prototype.$isPhone = function(value) {
  const isPhone = /^([0-9]{3,4}-)?[0-9]{7,8}$/
  return isPhone.test(value)
}
/**
 * 验证手机号
 */
Vue.prototype.$isMobile = function(value) {
  const myMobile = /^[1][0-9]{10}$/
  return myMobile.test(value)
}
/**
 * table 导出EXCEL（支持选中导出，支持查询导出，支持整个table导出）---
 *
 * id:table的id,
 * title:导出的excel名字,
 * pageColumns:表头列
 * selectData：表格数据（可以是选中的，也可以是全部数据，若要导出全部数据则需执行page方法，page:1,rows:5000,最多导出5000条数据）
 *
 */
Vue.prototype.$exportExcel = function(id, title, pageColumns, selectData) {
  // 正在导出的提示...
  this.$Message.loading({
    content: '正在导出，请稍后...',
    duration: 0
  })

  // 创建一个div(原生)
  const parentdiv = document.createElement('div')

  // 自制表头(循环pageColumns)
  const theadTr = document.createElement('tr')
  const tbodyTr = document.createElement('tbody')
  /** ***********************表数据**************************/
  // 只导出选中的数据
  for (let j = 0; j < selectData.length; j++) {
    const tr = document.createElement('tr')
    const selectDataIndex = selectData[j]
    for (let k = 0; k < pageColumns.length; k++) {
      const td = document.createElement('td')
      if (pageColumns[k].date) {
        // 日期格式化 --- yyyy-mm-dd
        td.innerHTML = selectDataIndex[pageColumns[k].key]
          ? this.$dateformat(selectDataIndex[pageColumns[k].key], 'yyyy-mm-dd')
          : ''
      } else if (pageColumns[k].dateTime) {
        // 日期格式化--- yyyy-mm-dd HH:MM:ss
        td.innerHTML = selectDataIndex[pageColumns[k].key]
          ? this.$dateformat(
              selectDataIndex[pageColumns[k].key],
              'yyyy-mm-dd HH:MM:ss'
            )
          : ''
      } else if (pageColumns[k].key === 'status' && pageColumns[k].ADataEntry) {
        td.innerHTML = selectDataIndex[pageColumns[k].key]
          ? selectDataIndex[pageColumns[k].key].display
          : ''
      } else if (pageColumns[k].key === 'status') {
        td.innerHTML =
          selectDataIndex[pageColumns[k].key] === 0
            ? '禁用'
            : selectDataIndex[pageColumns[k].key] === 1
              ? '正常'
              : '待激活'
      } else if (pageColumns[k].key === 'oked') {
        td.innerHTML =
          selectDataIndex[pageColumns[k].key] === 't' ? '不合格' : '合格'
      } else if (pageColumns[k].key === 'singleJudge') {
        td.innerHTML = selectDataIndex[pageColumns[k].key]
          ? selectDataIndex[pageColumns[k].key].display
          : ''
      } else if (pageColumns[k].key === 'unit') {
        td.innerText =
          selectDataIndex[pageColumns[k].key] === undefined
            ? ''
            : selectDataIndex[pageColumns[k].key] === '%'
              ? '`%'
              : selectDataIndex[pageColumns[k].key]
      } else if (pageColumns[k].key === 'judged') {
        td.innerText = selectDataIndex[pageColumns[k].key] === 1 ? '是' : '否'
      } else if (pageColumns[k].key === 'qualifiedProduct') {
        td.innerText =
          selectDataIndex[pageColumns[k].key] === 't' ? 'B级' : 'A级'
      } else if (pageColumns[k].key === 'canMake') {
        td.innerText =
          selectDataIndex[pageColumns[k].key] === '1' ? '已准许' : '未准许'
      } else {
        // 普通文本
        td.innerHTML =
          selectDataIndex[pageColumns[k].key] === undefined
            ? ''
            : selectDataIndex[pageColumns[k].key]
      }

      tr.appendChild(td)
    }
    tbodyTr.appendChild(tr)
  }

  /** ***********************表头信息********************************/

  for (let i = 0; i < pageColumns.length; i++) {
    const th = document.createElement('th')
    th.innerHTML = pageColumns[i].title
    theadTr.appendChild(th)
  }

  /** *************************表头+内容进行拼接**********************************/

  parentdiv.appendChild(theadTr)
  parentdiv.appendChild(tbodyTr)

  /** *************************导出**********************************/
  const xlsxParam = { raw: true }
  const wb = XLSX.utils.table_to_book(parentdiv, xlsxParam)

  /* get binary string as output */
  const wbout = XLSX.write(wb, {
    bookType: 'xlsx',
    bookSST: true,
    type: 'array'
  })
  try {
    FileSaver.saveAs(
      new Blob([wbout], { type: 'application/octet-stream' }),
      title + '.xlsx'
    )
  } catch (e) {
    if (typeof console !== 'undefined') console.log(e, wbout)
  }

  // 销毁导出提示
  setTimeout(() => {
    this.$Message.destroy()
    return wbout
  }, 1500)
}
Vue.prototype.$exportExcelNew = function(
  id,
  excelTitle,
  pageColumns,
  selectData
) {
  // 导出表格的表头设置
  const allColumns = pageColumns
  const columnNames = []
  const columnValues = []
  for (let i = 0; i < allColumns.length; i++) {
    columnNames[i] = allColumns[i].title
    columnValues[i] = allColumns[i].key
  }
  require.ensure([], () => {
    // eslint-disable-next-line camelcase
    const { export_json_to_excel } = require('./vendor/Export2Excel')
    const tHeader = columnNames
    const filterVal = columnValues
    const list = JSON.parse(JSON.stringify(selectData))
    // 字段转换
    for (let j = 0; j < list.length; j++) {
      const selectDataIndex = list[j]
      for (let k = 0; k < pageColumns.length; k++) {
        const listKey = selectDataIndex[pageColumns[k].key]
        if (pageColumns[k].date) {
          // 日期格式化 --- yyyy-mm-dd
          list[j][[pageColumns[k].key]] = listKey
            ? this.$dateformat(listKey, 'yyyy-mm-dd')
            : ''
        } else if (pageColumns[k].dateTime) {
          // 日期格式化 --- yyyy-mm-dd HH:MM:ss
          list[j][[pageColumns[k].key]] = listKey
            ? this.$dateformat(listKey, 'yyyy-mm-dd HH:MM:ss')
            : ''
        } else if (pageColumns[k].datetime) {
          // 日期格式化 --- yyyy-mm-dd HH:MM:ss
          list[j][[pageColumns[k].key]] = listKey
            ? this.$dateformat(listKey, 'yyyy-mm-dd HH:MM:ss')
            : ''
        } else if (pageColumns[k].status) {
          // 状态
          list[j][[pageColumns[k].key]] =
            listKey === undefined ? '' : listKey.display
        } else {
          list[j][[pageColumns[k].key]] = listKey === undefined ? '' : listKey
        }
      }
    }
    const data = this.$formatJson(filterVal, list)
    export_json_to_excel(tHeader, data, excelTitle)
    // 销毁导出提示
    setTimeout(() => {
      this.$Message.destroy()
    }, 1500)
  })
}
Vue.prototype.$formatJson = function(filterVal, jsonData) {
  return jsonData.map(v => filterVal.map(j => v[j]))
}
/**
 * 重置数据
 * */
Vue.prototype.$resetFields = function(formObj) {
  for (const key in formObj) {
    formObj[key] = ''
  }
  return formObj
}
Vue.prototype.$layx = function(id, title, url, option) {
  // eslint-disable-next-line no-undef
  layx.iframe(id, title, url, option || { width: '100%', height: '100%' })
}
/**
 *搜索条件清空缓存处理方式(form表单 查询)
 *
 */

Vue.prototype.$serializeForm = function(formObj) {
  const newFormObj = {}
  for (const key in formObj) {
    // 不为空的时候传值
    if (formObj[key] !== '') {
      newFormObj[key] = formObj[key]
    }
  }
  return newFormObj
}
// noinspection JSAnnotator
/***
 *生成N位随机数
 * */
Vue.prototype.$randomCode = function() {
  let code = ''
  const random = [
    0,
    1,
    2,
    3,
    4,
    5,
    6,
    7,
    8,
    9,
    'A',
    'B',
    'C',
    'D',
    'E',
    'F',
    'G',
    'H',
    'I',
    'J',
    'K',
    'L',
    'M',
    'N',
    'O',
    'P',
    'Q',
    'R',
    'S',
    'T',
    'U',
    'V',
    'W',
    'X',
    'Y',
    'Z'
  ]
  // 循环codeLength 设置的n就是循环n次 n:6
  for (let i = 0; i < 4; i++) {
    // 设置随机数范围,这设置为0 ~ 36
    const index = Math.floor(Math.random() * 36)
    // 字符串拼接 将每次随机的字符 进行拼接
    code += random[index]
  }
  return new Date().getTime() + code
}
/**
 *去重
 */
Vue.prototype.$uniqueArray = function(arr, item) {
  for (let i = 0; i < arr.length; i++) {
    const arri = arr[i]
    for (let j = i + 1; j < arr.length; j++) {
      const arrj = arr[j]
      if (arri[item] === arrj[item]) {
        arr.splice(j, 1)
        j--
      }
    }
  }
  return arr
}
/**
 *临时存放系统管理的菜单信息，该分支修改完成，统一修改数据库即可
 *
 */
Vue.prototype.$sysMenus = function() {
  const result = [
    {
      name: '系统管理',
      leftMenus: [
        {
          name: '系统管理',
          subMenus: [
            {
              name: '菜单权限管理',
              uri: '/sys/sys_manage/menu'
            },
            {
              name: '按钮权限管理',
              uri: '/sys/sys_manage/btn'
            },
            {
              name: '表格权限管理',
              uri: '/sys/sys_manage/table'
            },
            {
              name: '报表设计',
              uri: '/sys/sys_manage/report_design'
            },
            {
              name: '报表配置',
              uri: '/sys/sys_manage/report_config'
            },
            {
              name: '表单管理',
              uri: '/sys/sys_manage/form_manage'
            },
            {
              name: '表单配置',
              uri: '/sys/sys_manage/form_config'
            },
            {
              name: '操作日志',
              uri: '/sys/sys_manage/log'
            },
            {
              name: '黑名单管理',
              uri: '/sys/sys_manage/black_list'
            },
            {
              name: '系统模块管理',
              uri: '/sys/sys_manage/module'
            },
            {
              name: '平台管理',
              uri: '/sys/sys_manage/system'
            },
            {
              name: '水印管理',
              uri: '/sys/sys_manage/watermark'
            }
          ],
          uri: '/'
        },
        {
          name: '系统配置',
          subMenus: [
            {
              name: '企业管理',
              uri: '/sys/sys_config/company'
            },
            {
              name: '组织管理',
              uri: '/sys/sys_config/org'
            },
            {
              name: '角色管理',
              uri: '/sys/sys_config/role'
            },
            {
              name: '用户管理',
              uri: '/sys/sys_config/user'
            },
            {
              name: '模版管理',
              uri: '/sys/sys_config/print_template'
            },
            {
              name: '编号管理',
              uri: '/sys/sys_config/code_rule'
            },
            {
              name: '模块管理',
              uri: '/sys/sys_config/print_module'
            }
          ],
          uri: '/'
        },
        {
          name: '工作流管理',
          subMenus: [
            {
              name: '我的任务',
              uri: '/sys/workflow/flow_task'
            },
            {
              name: '工作组管理',
              uri: '/sys/workflow/flow_group'
            },
            {
              name: '流程部署列表',
              uri: '/sys/workflow/flow_process'
            }
          ],
          uri: '/workflow'
        },
        {
          name: '个人资料',
          subMenus: [
            {
              name: '修改密码',
              uri: '/sys/personal_data/password_edit'
            },
            {
              name: '我的首页',
              uri: '/sys/personal_data/my_home'
            },
            {
              name: '基本信息',
              uri: '/sys/personal_data/base_info'
            },
            {
              name: '微信绑定',
              uri: '/sys/personal_data/wechat'
            }
          ],
          uri: '/'
        },
        {
          name: '基础管理',
          subMenus: [
            {
              name: '国家管理',
              uri: '/sys/base_manage/country'
            },
            {
              name: '省份管理',
              uri: '/sys/base_manage/province'
            },
            {
              name: '城市管理',
              uri: '/sys/base_manage/city'
            },
            {
              name: '地区管理',
              uri: '/sys/base_manage/area'
            }
          ],
          uri: '/'
        },
        {
          name: '消息管理',
          subMenus: [
            {
              name: '消息管理',
              uri: '/sys/message_manage/message'
            },
            {
              name: '消息类型配置',
              uri: '/sys/message_manage/message_type'
            },
            {
              name: '我的消息',
              uri: '/sys/message_manage/my_message'
            }
          ],
          uri: '/'
        }
      ],
      code: 'sys',
      uri: 'http://web.dev.patzn.com:8096'
    }
  ]
  return result
}
// Vue.prototype.$uniqueArrayItem = function(arr, item) {
//   for (let i = 0; i < arr.length - 1; i++) {
//     const arri = arr[i]
//     for (let j = i + 1; j < arr.length; j++) {
//       const arrj = arr[j]
//       if (arri[item] === arrj[item]) {
//         arr.splice(j, 1)
//         j--
//       }
//     }
//   }
//   return arr
// }
/**
 * pageoffice(可编辑)
 * objectKey,id,isReport(1是报告，可编辑;0是不可编辑)
 * 地址栏需要对中文进行编码处理
 *
 */
Vue.prototype.$platform = function() {
  let isWin = false
  if (navigator.platform === 'Win32' || navigator.platform === 'Windows') {
    isWin = true
  }
  return isWin
}
// Vue.prototype.$openWindowModeless = function(data) {
//   if (this.$platform()) {
//     // windows系统
//
//     // id 为报告id或者委托id
//     const noMark = data.noMark
//     const realname = encodeURI(encodeURI(global.getUserInfo().realname))
//     const companyId = global.getUserInfo().companyId
//     const userId = global.getUserInfo().id
//
//     const uri =
//       global.baseURL +
//       '/print/v1/word?key=' +
//       data.objectKey +
//       '&sysMark=' +
//       (noMark ? '' : global.getCode()) +
//       '&businessId=' +
//       data.id +
//       '&isReport=' +
//       (data.isReport ? data.isReport : 0) +
//       '&userId=' +
//       userId +
//       '&userName=' +
//       realname +
//       '&companyId=' +
//       companyId +
//       '&noParam=no'
//     console.log(uri)
//     return POBrowser.openWindowModeless(uri, 'width=1200px;height=800px;')
//   } else {
//     // 其他系统
//
//     window.open(
//       global.baseURL + '/print/v1/oos?key=' + data.objectKey + '&edit=true',
//       '',
//       'height=' +
//         (screen.availHeight - 50) +
//         ',' +
//         'width=' +
//         (screen.availWidth - 10) +
//         ',top=0,left=0,toolbar=no,menubar=no,scrollbars=auto,resizeable=no,' +
//         'location=no,status=no'
//     )
//   }
// }
Vue.prototype.$openWindowModeless = function(data) {
  // id 为样品id或者委托id
  const realname = encodeURI(encodeURI(global.getUserInfo().realname))
  const uri =
    global.baseURL +
    '/print/v1/word?key=' +
    data.objectKey +
    '&sysMark=' +
    global.getCode() +
    '&businessId=' +
    data.id +
    '&isReport=' +
    data.isReport +
    '&userId=' +
    global.getUserInfo().id +
    '&companyId=1304005330061996033' +
    '&userName=' +
    realname +
    '&idType=' +
    data.idType
  // eslint-disable-next-line no-undef
  return POBrowser.openWindowModeless(uri, 'width=1200px;height=800px;')
}

Vue.prototype.$pdfView = function(data) {
  if (data) {
    // 根据objectKey下载pdf
    const fileUrl = encodeURIComponent(
      global.baseURL + '/print/v1/download?objectKey='
    )
    const uri =
      global.staticURL +
      '/pdf/PDFJS/pdfjs/web/viewer.html?file=' +
      fileUrl +
      data
    return window.open(uri, '_blank')
  } else {
    this.$Message.warning('暂无PDF生成，不可预览~')
  }
}
/**
 * pageoffice(打印word,pdf(待定))
 * id
 *
 */
Vue.prototype.$pageofficePrint = function(data) {
  // id 为样品id或者委托id
  const companyId = global.getUserInfo().companyId
  const realname = encodeURI(encodeURI(global.getUserInfo().realname))
  const userId = global.getUserInfo().id
  const locaName = encodeURI('报告')
  // id 为报告id或者委托id
  const type = encodeURI(data.type)
  const ids = data.ids.join(',')
  const uri =
    global.baseURL +
    '/print/v1/batch_print_meter' +
    '?sysMark=' +
    global.getCode() +
    '&location=' +
    locaName +
    '&companyId=' +
    companyId +
    '&userId=' +
    userId +
    '&username=' +
    realname +
    '&printType=' +
    type +
    '&businessIds=' +
    ids
  // eslint-disable-next-line no-undef
  return POBrowser.openWindowModeless(uri, 'width=350px;height=300px;')
}

/**
 * 库存组织公用接口
 * */
// 正式地址 192.168.81.76:8088
Vue.prototype.$stockOrganize = function() {
  const url = `${global.ncURL}/service/LimsZjStockorg?data=`
  const _this = this
  return new Promise((resolve, reject) => {
    $.ajax({
      type: 'GET',
      url: url,
      data: {},
      headers: {
        'Content-Type': 'multipart/form-data'
      },
      dataType: 'jsonp',
      success: data => {
        switch (data.flag.toString()) {
          case '0':
            _this.$Message.error(data.message)
            break
          case '1':
            if (data.vos !== '') {
              resolve(JSON.parse(data.vos))
            } else {
              _this.$Message.warning(data.message)
            }
            break
        }
      },
      error: function(data) {
        console.log('12121212121212', data)
      }
    })
  })
}
/**
 * 统计分析模块 公用计算 一列属性
 * 通过 Object.values() 将对象中的属性取出到一个数组中
 * 遍历 数组中对应属性，将对应属性取出进行相加，利用了
 * */
Vue.prototype.$statistics = (arr, obj, obj1) => {
  arr.forEach(item =>
    obj.forEach(
      i =>
        (obj1[item] =
          obj1[item] === undefined
            ? i[item]
            : obj1[item] + (i[item] ? i[item] : 0))
    )
  )
  return obj1
}
// 计算当月天数
Vue.prototype.$countDays = function() {
  const curDate = new Date()
  return (
    new Date(curDate.getFullYear(), curDate.getMonth() + 1, 0).getDate() *
    86400000
  )
}

Vue.prototype.$optColWidth = function(list) {
  const arrayList = []
  const width = 20
  for (const i in list) {
    if (this.$showBtn(list[i].id)) {
      arrayList.push(list[i])
    }
  }
  return arrayList.length > 0 ? 85 + width * (arrayList.length - 1) : 0
}
Vue.prototype.$defRow = 500
Vue.prototype.$setOptimization = function(msg) {
  // 默认 数据超过200条，启用虚拟加载，每次加载50条
  let result = { gt: 200, oSize: 100 }
  switch (msg) {
    case 'modal-normal':
      // 弹出框正常情况下-- 数据超过25条启用虚拟加载
      result = { gt: 25, oSize: 10, rSize: 25 }
      break
  }
  return result
}
