/**
 * 人员管理-人员基本信息相关
 */
import http from '../http'

export default {
  page: data => http.post('/res/v1/user_group/page', data).then(res => res),
  getGroup: data =>
    http.get('/res/v1/user_group/get_by_uid/' + data.uid).then(res => res),
  userPage: data =>
    http.post('/res/v1/user_group/page_rel_user', data).then(res => res),
  pageGroupUser: data =>
    http.post('/soil/v1/experiment/page_group_user', data).then(res => res),
  add: data => http.post('/res/v1/user_group/', data).then(res => res),
  edit: data =>
    http.put('/res/v1/user_group/' + data.id, data.obj).then(res => res),
  getById: id => http.get('/res/v1/user_group/' + id).then(res => res),
  setChargeman: data =>
    http
      .post(
        '/res/v1/user_rel_group/set_leader?ids=' +
          data.id +
          '&leader=' +
          data.leader
      )
      .then(res => res),

  deleteByIds: ids =>
    http.delete('/res/v1/user_group/?ids=' + ids).then(res => res),
  deletePeopleByIds: ids =>
    http
      .delete('/res/v1/user_group/delete_rel_user?ids=' + ids)
      .then(res => res),
  levelTree: () => http.put('/res/v1/staff_level/get_tree').then(res => res),
  levelTreeKeyword: data =>
    http.put('/res/v1/staff_level/get_tree?name=' + data).then(res => res),
  orgTreeList: data =>
    http.post('/base/v1/org/org_tree', data).then(res => res),
  list: data => http.post('/res/v1/staff_info/list', data).then(res => res),
  relUser: data =>
    http
      .post(
        '/res/v1/user_group/add_user_rel_group?group_id=' +
          data.id +
          '&userIds=' +
          data.ids +
          '&realNames=' +
          data.names
      )
      .then(res => res)
}
