/**
 * 工作台
 */

import http from '../http'
// import { https } from '../https'

export default {
  // 检测依据管理
  standardPage: data =>
    http.post('soil/v1/standard/page', data).then(res => res),
  standardGetById: data =>
    http.get('soil/v1/standard/' + data).then(res => res),
  standardSave: data => http.post('soil/v1/standard/', data).then(res => res),
  standardEdit: data =>
    http.put('soil/v1/standard/' + data.id, data.obj).then(res => res),
  standardDeleteById: data =>
    http.delete('soil/v1/standard/?ids=' + data).then(res => res),
  // 试验项目
  // page
  page: data => http.post('soil/v1/aptitude_exp/page', data).then(res => res),
  getById: data => http.get('soil/v1/aptitude_exp/' + data).then(res => res),
  deleteById: data =>
    http.delete('soil/v1/aptitude_exp/?ids=' + data).then(res => res),
  // 保存
  save: data => http.post('soil/v1/aptitude_exp/', data).then(res => res),
  edit: data =>
    http.put('soil/v1/aptitude_exp/' + data.id, data.obj).then(res => res),
  // 指标页面
  expItemPage: data =>
    http.post('soil/v1/exp_item/page', data).then(res => res),
  expItemDeleteByIds: data =>
    http.delete('soil/v1/exp_item/?ids=' + data).then(res => res),
  expItemSave: data => http.post('soil/v1/exp_item/', data).then(res => res),
  expItemEdit: data =>
    http.put('soil/v1/exp_item/' + data.id, data.obj).then(res => res),
  expItemGetById: data => http.get('soil/v1/exp_item/' + data).then(res => res)
}
