/**
 * 工作台
 */

import http from '../http'
import { https } from '../https'

export default {
  // page
  page: data => http.post('soil/v1/entrust/page', data).then(res => res),
  pageReview: data =>
    http.post('soil/v1/entrust/page_review', data).then(res => res),
  pageSampleReceive: data =>
    http.post('soil/v1/entrust/page_sample_receive', data).then(res => res),
  getById: data => http.get('soil/v1/entrust/' + data).then(res => res),
  getVOById: data => http.get('soil/v1/entrust/vo/' + data).then(res => res),
  deleteById: data =>
    http.delete('soil/v1/entrust/?ids=' + data).then(res => res),
  // 保存
  save: data =>
    https
      .post('soil/v1/entrust/add_entrust', JSON.stringify(data))
      .then(res => res),
  edit: data => http.put('soil/v1/entrust/' + data.id, data.obj),
  editDTO: data =>
    https
      .post('soil/v1/entrust/edit_entrust', JSON.stringify(data))
      .then(res => res),
  submit: data =>
    https.post('soil/v1/entrust/submit_to_review?ids=' + data).then(res => res),
  submitSkipReview: data =>
    https
      .post('soil/v1/entrust/submit_to_skip_review?ids=' + data)
      .then(res => res),
  back: data =>
    http
      .post(
        'soil/v1/entrust/review_back?ids=' + data.ids + '&reason=' + data.remark
      )
      .then(res => res),
  reviewPass: data =>
    http.post('soil/v1/entrust/review_pass?ids=' + data).then(res => res),
  samplePage: data => http.post('soil/v1/sample/page', data).then(res => res),
  pageReceive: data =>
    http.post('soil/v1/sample/page_receive', data).then(res => res),
  pageSend: data => http.post('soil/v1/sample/page_send', data).then(res => res)
}
