﻿import Store from 'store2'
let CreatedOKLodop7766 = null
const lodop = Store.session.get('lodop')

//= ===判断是否需要安装CLodop云打印服务器:====
export function needCLodop() {
  if (lodop === false) {
    return false
  }
  try {
    const ua = navigator.userAgent
    if (ua.match(/Windows\sPhone/i) != null) return true
    if (ua.match(/iPhone|iPod/i) != null) return true
    if (ua.match(/Android/i) != null) return true
    if (ua.match(/Edge\D?\d+/i) != null) return true

    const verTrident = ua.match(/Trident\D?\d+/i)
    const verIE = ua.match(/MSIE\D?\d+/i)
    let verOPR = ua.match(/OPR\D?\d+/i)
    let verFF = ua.match(/Firefox\D?\d+/i)
    const x64 = ua.match(/x64/i)
    if (verTrident == null && verIE == null && x64 !== null) return true
    else if (verFF !== null) {
      verFF = verFF[0].match(/\d+/)
      if (verFF[0] >= 41 || x64 !== null) return true
    } else if (verOPR !== null) {
      verOPR = verOPR[0].match(/\d+/)
      if (verOPR[0] >= 32) return true
    } else if (verTrident == null && verIE == null) {
      let verChrome = ua.match(/Chrome\D?\d+/i)
      if (verChrome !== null) {
        verChrome = verChrome[0].match(/\d+/)
        if (verChrome[0] >= 41) return true
      }
    }
    return false
  } catch (err) {
    if (process.browser) {
      sessionStorage.setItem('lodop', true)
    }
    return true
  }
}

// ====页面引用CLodop云打印必须的JS文件：====
if (needCLodop()) {
  if (lodop || lodop == null) {
    // https://api.jquery.com/jquery.getscript/
    // const src1 = 'http://localhost:8000/CLodopfuncs.js?priority=1'
    // const src2 = 'http://localhost:18000/CLodopfuncs.js?priority=0'

    if (!process.browser) {
    } else {
      $.getScript(
        'http://localhost:8000/CLodopfuncs.js?priority=1',
        function() {
          const head =
            document.head ||
            document.getElementsByTagName('head')[0] ||
            document.documentElement
          const script = document.createElement('script')
          script.src = 'http://localhost:8000/CLodopfuncs.js?priority=1'
          head.insertBefore(script, head.firstChild)

          // // 引用双端口(8000和18000）避免其中某个被占用：
          // const script1 = document.createElement('script')
          // script1.src = 'http://localhost:18000/CLodopfuncs.js?priority=0'
          // head.insertBefore(script, head.firstChild)
          sessionStorage.setItem('lodop', true)
        }
      ).fail(function() {
        sessionStorage.setItem('lodop', false)
      })
    }
  }
}

//= ===获取LODOP对象的主过程：====
export function getLodop(oOBJECT, oEMBED) {
  if (!Store.session.get('lodop')) {
    return
  }
  // const strHtmInstall =
  //   "<br><font color='#FF00FF'>打印控件未安装!点击这里<a href='install_lodop32.exe' target='_self'>执行安装</a>,安装后请刷新页面或重新进入。</font>"
  const strHtmUpdate =
    "<br><font color='#FF00FF'>打印控件需要升级!点击这里<a href='install_lodop32.exe' target='_self'>执行升级</a>,升级后请重新进入。</font>"
  // const strHtm64Install =
  //   "<br><font color='#FF00FF'>打印控件未安装!点击这里<a href='install_lodop64.exe' target='_self'>执行安装</a>,安装后请刷新页面或重新进入。</font>"
  const strHtm64Update =
    "<br><font color='#FF00FF'>打印控件需要升级!点击这里<a href='install_lodop64.exe' target='_self'>执行升级</a>,升级后请重新进入。</font>"
  // const strHtmFireFox =
  //   "<br><br><font color='#FF00FF'>（注意：如曾安装过Lodop旧版附件npActiveXPLugin,请在【工具】->【附加组件】->【扩展】中先卸它）</font>"
  // const strHtmChrome =
  //   "<br><br><font color='#FF00FF'>(如果此前正常，仅因浏览器升级或重安装而出问题，需重新执行以上安装）</font>"
  const strCLodopInstall =
    "<br><font color='#FF00FF'>CLodop云打印服务(localhost本地)未安装启动!点击这里<a href='CLodop_Setup_for_Win32NT.exe' target='_self'>执行安装</a>,安装后请刷新页面。</font>"
  const strCLodopUpdate =
    "<br><font color='#FF00FF'>CLodop云打印服务需升级!点击这里<a href='CLodop_Setup_for_Win32NT.exe' target='_self'>执行升级</a>,升级后请刷新页面。</font>"
  let LODOP
  try {
    const isIE =
      navigator.userAgent.indexOf('MSIE') >= 0 ||
      navigator.userAgent.indexOf('Trident') >= 0
    if (needCLodop()) {
      try {
        /* eslint-disable no-undef */
        LODOP = getCLodop()
      } catch (err) {}
      if (!LODOP && document.readyState !== 'complete') {
        alert('C-Lodop没准备好，请稍后再试！')
        return
      }
      if (!LODOP) {
        if (isIE) document.write(strCLodopInstall)
        // document.body.innerHTML=strCLodopInstall+document.body.innerHTML;
        else return
      } else {
        if (CLODOP.CVERSION < '3.0.3.7') {
          if (isIE) document.write(strCLodopUpdate)
          else
            document.body.innerHTML = strCLodopUpdate + document.body.innerHTML
        }
        if (oEMBED && oEMBED.parentNode) oEMBED.parentNode.removeChild(oEMBED)
        if (oOBJECT && oOBJECT.parentNode)
          oOBJECT.parentNode.removeChild(oOBJECT)
      }
    } else {
      /* eslint-disable no-var */
      var is64IE = isIE && navigator.userAgent.indexOf('x64') >= 0
      //= ====如果页面有Lodop就直接使用，没有则新建:==========
      if (oOBJECT !== undefined || oEMBED !== undefined) {
        if (isIE) LODOP = oOBJECT
        else LODOP = oEMBED
      } else if (CreatedOKLodop7766 == null) {
        LODOP = document.createElement('object')
        LODOP.setAttribute('width', 0)
        LODOP.setAttribute('height', 0)
        LODOP.setAttribute(
          'style',
          'position:absolute;left:0px;top:-100px;width:0px;height:0px;'
        )
        if (isIE)
          LODOP.setAttribute(
            'classid',
            'clsid:2105C259-1E0C-4534-8141-A753534CB4CA'
          )
        else LODOP.setAttribute('type', 'application/x-print-lodop')
        document.documentElement.appendChild(LODOP)
        CreatedOKLodop7766 = LODOP
      } else LODOP = CreatedOKLodop7766
      //= ====Lodop插件未安装时提示下载地址:==========
      if (LODOP == null || typeof LODOP.VERSION === 'undefined') {
        // if (navigator.userAgent.indexOf('Chrome') >= 0)
        //   document.body.innerHTML = strHtmChrome + document.body.innerHTML
        // if (navigator.userAgent.indexOf('Firefox') >= 0)
        //   document.body.innerHTML = strHtmFireFox + document.body.innerHTML
        // if (is64IE) document.write(strHtm64Install)
        // else if (isIE) document.write(strHtmInstall)
        // else document.body.innerHTML = strHtmInstall + document.body.innerHTML
        return LODOP
      }
    }
    if (LODOP.VERSION < '6.2.2.1') {
      if (!needCLodop()) {
        if (is64IE) document.write(strHtm64Update)
        else if (isIE) document.write(strHtmUpdate)
        else document.body.innerHTML = strHtmUpdate + document.body.innerHTML
      }
      return LODOP
    }
    //= ==如下空白位置适合调用统一功能(如注册语句、语言选择等):===
    LODOP.SET_LICENSES(
      '青岛帕特智能科技有限公司',
      '1BDA5C2F8EE17DEDB2DCDA4CA683CA12',
      '',
      ''
    )
    //= ==========================================================
    return LODOP
  } catch (err) {
    alert('getLodop出错:' + err)
  }
}
//
