/**
 * 组织表相关
 */

import http from '../http'

export default {
  page: data => http.post('/base/v1/org/page', data).then(res => res),
  add: data => http.post('/base/v1/org/', data).then(res => res),
  edit: data => http.put('/base/v1/org/' + data.id, data.obj).then(res => res),
  getById: id => http.get('/base/v1/org/vo_' + id).then(res => res),
  // 组织树
  orgTreeList: data =>
    http.post('/base/v1/org/org_tree', data).then(res => res),
  // 组织树search
  orgTreeKeyword: data =>
    http.post('/base/v1/org/org_tree?keyword=' + data).then(res => res),
  // 分配机构ztree
  orginTreeList: () => http.post('/base/v1/org/org_tree').then(res => res),
  // 当前用户所在部门
  getOrg: () => http.get('/base/v1/org/current').then(res => res)
}
