const pkg = require('./package')
require('dotenv').config()

// 系统环境变量，测试环境编译：NODE_ENV=testing nuxt build
let envFilename = '.env.development'
if (process.env.NODE_ENV) {
  envFilename = '.env.' + process.env.NODE_ENV
}
module.exports = {
  mode: 'universal',
  server: {
    port: 8130,
    host: '0.0.0.0'
  },
  /*
  ** Headers of the page
  */
  head: {
    title: '计量检定LIMS',
    meta: [
      { charset: 'utf-8' },
      { name: 'viewport', content: 'width=device-width, initial-scale=1' },
      { hid: 'description', name: 'description', content: pkg.description }
    ],
    script: [
      { src: 'http://static.patzn.com/js/jquery-3.3.1.min.js' },
      {
        src:
          'http://static.patzn.com/thirdparty/ztree/zTree_v3-3.5.29/js/jquery.ztree.all.min.js'
      }
    ],
    link: [
      {
        rel: 'icon',
        type: 'image/x-icon',
        href: 'http://static.patzn.com/favicon.ico'
      },
      {
        rel: 'stylesheet',
        href:
          'http://static.patzn.com/thirdparty/ztree/zTree_v3-3.5.29/css/metroStyle/metroStyle.css'
      },
      {
        rel: 'stylesheet',
        href: 'http://static.patzn.com/thirdparty/ztree/menuStyle.css'
      },
      {
        rel: 'stylesheet',
        href: 'http://static.patzn.com/css/animate.css'
      },
      {
        rel: 'stylesheet',
        href: 'http://static.patzn.com/theme/my-theme/main.css'
      },
      { rel: 'stylesheet', href: '', name: 'theme' }
    ]
  },

  /*
  ** Customize the progress-bar color
  */
  loading: { color: '#00a0e9' },

  /*
  ** Global CSS
  */
  css: [
    // { src: 'assets/css/main.less' },
    { src: 'assets/css/main.less' },
    { src: 'element-ui/lib/theme-chalk/index.css' },
    { src: 'iview/dist/styles/iview.css' },
    { src: 'assets/my-theme/b.less' },
    { src: 'assets/icons/iconfont.css' }
  ],
  /*
  ** Plugins to load before mounting the App; ssr选项设置为false，这样服务端渲染时就不会渲染这个组件了
  */
  plugins: [
    { src: '~/plugins/iview.js', ssr: true },
    { src: '~/plugins/element-ui.js', ssr: true },
    { src: '~/plugins/common.js', ssr: true },
    { src: '~/plugins/drag.js', ssr: true },
    { src: '~/plugins/global.js', ssr: true },
    { src: '~/plugins/editor.js', ssr: false },
    { src: '@/plugins/gallery.js', ssr: false },
    { src: '@/plugins/ieCharts.js', ssr: false }
  ],

  /*
  ** Nuxt.js sub
  */
  modules: [
    // Doc: https://axios.nuxtjs.org/usage
    '@nuxtjs/axios',
    '@nuxtjs/router',
    ['@nuxtjs/dotenv', { path: './env', filename: envFilename }],
    'cookie-universal-nuxt'
  ],
  /*
  ** Axios sub configuration
  */
  axios: {
    // See https://github.com/nuxt-community/axios-module#options
  },

  /*
   * less
   */
  loader: [
    {
      test: /\.less$/,
      loaders: 'style-loader!css-loader!less-loader'
    }
  ],

  /*
  ** Build configuration
  */
  build: {
    /*
    ** You can extend webpack config here
    */
    extend(config, ctx) {
      // Run ESLint on save
      if (ctx.isDev && ctx.isClient) {
        config.module.rules.push({
          enforce: 'pre',
          test: /\.(js|vue)$/,
          loader: 'eslint-loader',
          // https://github.com/webpack-contrib/eslint-loader#formatter-default-eslint-stylish-formatter
          options: {
            // 忽略警告
            quiet: true
          },
          exclude: /(node_modules)(clodop)/
        })
      }
      // 打包编译压缩，移除 console 日志
      if (!ctx.isDev) {
        const UglifyJSWebpackPlugin = require('uglifyjs-webpack-plugin')
        config.plugins = config.plugins.filter(
          plugin => plugin.constructor.name !== 'UglifyJsPlugin'
        )
        config.plugins.push(
          new UglifyJSWebpackPlugin({
            cache: true,
            parallel: true,
            uglifyOptions: {
              compress: { drop_console: true }
            }
          })
        )
      }
    },
    vendor: [
      '~/plugins/iview.js',
      '~/plugins/element-ui.js',
      '~/plugins/vue-inject.js'
    ]
  }
}
