/**
 * 工作台
 */

import http from '../http'
import { https } from '../https'

export default {
  // page
  page: data =>
    http.post('meter/v1/sub_contract/page_vo', data).then(res => res),
  pageSubmit: data =>
    http.post('meter/v1/sub_contract/page_have_submit', data).then(res => res),
  getById: data => http.get('meter/v1/sub_contract/' + data).then(res => res),
  getDTOById: data =>
    http.get('meter/v1/sub_contract/dto/' + data).then(res => res),
  // 删除
  deleteById: data =>
    http.delete('meter/v1/sub_contract/?ids=' + data).then(res => res),
  // 保存
  save: data => http.post('meter/v1/sub_contract/', data).then(res => res),
  submit: data =>
    http.post('meter/v1/sub_contract/submit?ids=' + data).then(res => res),
  addSubContract: data =>
    https
      .post('meter/v1/sub_contract/add_sub_contract', JSON.stringify(data))
      .then(res => res),
  editSubContract: data =>
    https
      .post('meter/v1/sub_contract/edit_sub_contract', JSON.stringify(data))
      .then(res => res),
  // 编辑
  edit: data =>
    http.put('meter/v1/sub_contract/' + data.id, data.obj).then(res => res)
}
