/**
 * 工作台
 */

import http from '../http'
import { https } from '../https'

export default {
  // page
  locationPage: data =>
    http.post('soil/v1/receive_location/page', data).then(res => res),
  locationList: data =>
    http.post('soil/v1/receive_location/list', data).then(res => res),
  locationGetById: data =>
    http.get('soil/v1/receive_location/' + data).then(res => res),
  locationSave: data =>
    http.post('soil/v1/receive_location/', data).then(res => res),
  locationDeleteById: data =>
    http.delete('soil/v1/receive_location/?ids=' + data).then(res => res),
  locationEdit: data =>
    http.put('soil/v1/receive_location/' + data.id, data.obj).then(res => res),
  // 试验室领样操作
  takeSample: data =>
    http.post('soil/v1/sample/take_sample?ids=' + data).then(res => res),
  // 备样历史分页列表
  pageBackupHis: data =>
    http.post('soil/v1/sample_backup/page_backup_his', data).then(res => res),
  // 备样管理提交申请
  appleHandle: data =>
    http.post('soil/v1/sample_backup/apply_handle', data).then(res => res),
  // 样品处理分页列表
  pageBackupHandleCheck: data =>
    http
      .post('soil/v1/sample_backup/page_backup_handle_check', data)
      .then(res => res),
  pageBackupHandleCheckHis: data =>
    http
      .post('soil/v1/sample_backup/page_backup_handle_check_his', data)
      .then(res => res),
  // 样品处理审批通过
  disposalOk: data =>
    http.post('soil/v1/sample_backup/disposal_ok?ids=' + data).then(res => res),
  // 样品处理审批驳回
  disposalFail: data =>
    http
      .post(
        'soil/v1/sample_backup/disposal_fail?ids=' +
          data.ids +
          '&reason=' +
          data.remark
      )
      .then(res => res),
  // 备样管理处理备样申请
  handleOk: data =>
    http.post('soil/v1/sample_backup/handle_ok?ids=' + data).then(res => res),
  pageSurplus: data =>
    http.post('soil/v1/prepare/page_surplus', data).then(res => res),
  // 余样处理审批分页列表
  pageSurplusHandleCheck: data =>
    http
      .post('soil/v1/prepare/page_surplus_handle_check', data)
      .then(res => res),
  // 余样管理处理备样申请
  surplusApplyHandle: data =>
    http.post('soil/v1/prepare/apply_handle', data).then(res => res),
  // 余样管理处理备样申请
  surplusHandleOk: data =>
    http.post('soil/v1/prepare/handle_ok?ids=' + data).then(res => res),
  // 余品处理审批通过
  surplusDisposalOk: data =>
    http.post('soil/v1/prepare/disposal_ok?ids=' + data).then(res => res),
  // 余样处理审批驳回
  surplueDisposalFail: data =>
    http
      .post(
        'soil/v1/prepare/disposal_fail?ids=' +
          data.ids +
          '&reason=' +
          data.remark
      )
      .then(res => res),
  // 余样样品历史分页列表
  pageSurplusHis: data =>
    http.post('soil/v1/prepare/page_surplus_his', data).then(res => res),
  // 报告模板
  reportTemplate: data =>
    http.post('soil/v1/report/page', data).then(res => res),
  reportMake: data =>
    https
      .post('soil/v1/report/make_report', JSON.stringify(data))
      .then(res => res),
  getReport: data =>
    http.get('soil/v1/report/get_report_' + data).then(res => res),
  getToken: data =>
    http.get('/print/url/get_access_token', data).then(res => res),
  // 报告编制提交至报告审核
  reportMakeSubmit: data =>
    http
      .post('soil/v1/entrust/report_make_submit?ids=' + data)
      .then(res => res),
  // 报告审核提交至报告签发
  reportCheckSubmit: data =>
    http
      .post('soil/v1/entrust/report_check_submit?ids=' + data)
      .then(res => res),
  // 报告审核退回至报告编制
  reportCheckBack: data =>
    http
      .post(
        'soil/v1/entrust/report_check_back?ids=' +
          data.ids +
          '&reason=' +
          data.remark
      )
      .then(res => res),
  // 报告签发提交
  reportIssueSubmit: data =>
    http
      .post('soil/v1/entrust/report_issue_submit?ids=' + data)
      .then(res => res),
  // 报告签发退回
  reportIssueBack: data =>
    http
      .post(
        'soil/v1/entrust/report_issue_back?ids=' +
          data.ids +
          '&reason=' +
          data.remark
      )
      .then(res => res),
  getDictList: data =>
    http.post('res/v1/dict/dict_query?type=' + data).then(res => res),
  editBackup: data =>
    http.put('soil/v1/sample_backup/' + data.id, data.obj).then(res => res),
  editItem: data =>
    http.post('soil/v1/experiment/bath_update_info', data).then(res => res),
  // 余样编辑
  editPrepare: data =>
    http.put('soil/v1/prepare/' + data.id, data.obj).then(res => res),
  getUserList: data => http.post('/base/v1/user/page').then(res => res),
  scanTakeSample: data =>
    http
      .post('soil/v1/sample/scan_take_sample?sampleCode=' + data)
      .then(res => res)
}
