/**
 * 工作台
 */

import http from '../http'
import { https } from '../https'

export default {
  // page
  page: data => http.post('meter/v1/entrust/page', data).then(res => res),
  pagePrintEntrust: data =>
    http.post('meter/v1/entrust/page_print_entrust', data).then(res => res),
  pagePrintedEntrust: data =>
    http.post('meter/v1/entrust/page_printed_entrust', data).then(res => res),
  // list
  pageList: data => http.get('res/v1/customer/list').then(res => res),

  // querylist
  pageQueryList: data =>
    http.get('/res/v1/customer/list?cname=' + data).then(res => res),
  pageSendEntrust: data =>
    http
      .post('meter/v1/entrust/page_send_draft_entrust', data)
      .then(res => res),
  pageSendEntrustHis: data =>
    http
      .post('meter/v1/entrust/page_send_draft_entrust_his', data)
      .then(res => res),

  pageDistributeEntrust: data =>
    http
      .post('meter/v1/entrust/page_distribute_entrust', data)
      .then(res => res),

  pageDistributeEntrustHis: data =>
    http
      .post('meter/v1/entrust/page_distribute_entrust_his', data)
      .then(res => res),

  pageGoOutEntrust: data =>
    http.post('meter/v1/entrust/page_out_draft_entrust', data).then(res => res),
  pageClientOnlineEntrust: data =>
    http
      .post('meter/v1/entrust/page_client_online_entrust', data)
      .then(res => res),
  pageGoOutEntrustHis: data =>
    http
      .post('meter/v1/entrust/page_out_draft_entrust_his', data)
      .then(res => res),
  pageOutTaskDistribute: data =>
    http
      .post('meter/v1/entrust/page_out_task_distribute', data)
      .then(res => res),
  pageOutTaskDistributeHis: data =>
    http
      .post('meter/v1/entrust/page_out_task_distribute_his', data)
      .then(res => res),
  pageEntrustReview: data =>
    http.post('meter/v1/entrust/page_review_entrust', data).then(res => res),

  pageEntrustProgress: data =>
    http.post('meter/v1/entrust/page_entrust_progress', data).then(res => res),

  pageEntrustReceive: data =>
    http
      .post('meter/v1/entrust/page_sample_receive_entrust', data)
      .then(res => res),

  pageEntrustReceiveHis: data =>
    http
      .post('meter/v1/entrust/page_sample_receive_entrust_his', data)
      .then(res => res),
  pageSubpackageEntrust: data =>
    http
      .post('meter/v1/entrust/page_subpackage_entrust', data)
      .then(res => res),
  pageSubpackageEntrustHis: data =>
    http
      .post('meter/v1/entrust/page_subpackage_entrust_his', data)
      .then(res => res),
  // 委托评审驳回
  back: data =>
    http
      .post(
        'meter/v1/entrust/review_back?ids=' +
          data.ids +
          '&reason=' +
          data.remark
      )
      .then(res => res),
  pageSubpackageInputEntrust: data =>
    http
      .post('meter/v1/entrust/page_subpackage_input_entrust', data)
      .then(res => res),
  // 操作日志
  pageOutTaskOperation: data =>
    http.post('soil/v1/entrust_record/page', data).then(res => res),
  // 任务分配操作日志
  pageTask: data =>
    http.post('meter/v1/sample_record/page', data).then(res => res),
  getById: data => http.get('meter/v1/entrust/' + data).then(res => res),
  getVOById: data => http.get('meter/v1/entrust/vo/' + data).then(res => res),
  deleteById: data =>
    http.delete('meter/v1/entrust/?ids=' + data).then(res => res),
  // 保存
  save: data =>
    https
      .post('meter/v1/entrust/add_send_entrust', JSON.stringify(data))
      .then(res => res),
  saveOutEntrust: data =>
    https
      .post('meter/v1/entrust/add_out_entrust', JSON.stringify(data))
      .then(res => res),
  editDTO: data =>
    https
      .post('meter/v1/entrust/edit_entrust', JSON.stringify(data))
      .then(res => res),
  editOnlineDTO: data =>
    https
      .post('meter/v1/entrust/edit_online_entrust', JSON.stringify(data))
      .then(res => res),
  // 提交
  submit: data =>
    https
      .post('meter/v1/entrust/submit_to_review?ids=' + data)
      .then(res => res),
  submitSkipReview: data =>
    https
      .post('meter/v1/entrust/submit_to_skip_review?ids=' + data)
      .then(res => res),
  submitToEntrustRegister: data =>
    https
      .post('meter/v1/entrust/submit_to_entrust_register?ids=' + data)
      .then(res => res),

  passReview: data =>
    http.post('meter/v1/entrust/pass_review?ids=' + data).then(res => res),

  // 编辑
  edit: data =>
    http.put('meter/v1/entrust/' + data.id, data.obj).then(res => res),
  // 省份
  getProvince: data => http.post('/base/v1/province/list_all').then(res => res),
  // 城市
  getCity: data => http.post('/base/v1/city/list_' + data).then(res => res),
  // 地区
  getArea: data => http.post('/base/v1/area/list_' + data).then(res => res),
  // 附件列表
  attachmentPage: (url, data) => http.post(url, data).then(res => res),
  // 附件删除
  attachmentDelete: (url, data) => http.delete(url + data).then(res => res),
  // 预览附件
  attachmentPreview: data =>
    http.post('/meter/v1/contract_attachment/preview/' + data).then(res => res),
  // 委托附件预览
  entrustPreview: data =>
    http.post('/meter/v1/entrust_attachment/preview/' + data).then(res => res),
  // 余样操作日志分页列表
  prepareRecordPage: data =>
    http.post('soil/v1/prepare_record/page', data).then(res => res),
  // 备样操作日志分页列表
  backupRecordPage: data =>
    http.post('soil/v1/sample_backup_record/page', data).then(res => res),
  experimentRecordPage: data =>
    http.post('soil/v1/experiment_record/page', data).then(res => res),
  pageGroupExpReportMake: data =>
    http
      .post('soil/v1/exp_report/page_group_exp_report_make', data)
      .then(res => res),
  pageGroupExpReportCheck: data =>
    http
      .post('soil/v1/exp_report/page_group_exp_report_check', data)
      .then(res => res),
  pageGroupExpReportIssue: data =>
    http
      .post('soil/v1/exp_report/page_group_exp_report_issue', data)
      .then(res => res),
  pageGroupExpReportEnd: data =>
    http
      .post('soil/v1/exp_report/page_group_exp_report_end', data)
      .then(res => res)
}
