package com.patzn.lims;

import com.patzn.lims.core.oss.EnableOss;
import com.patzn.lims.core.spring.SpringHelper;
import com.patzn.lims.core.starter.EnablePt;
import lombok.extern.slf4j.Slf4j;
import org.springframework.boot.Banner;
import org.springframework.boot.SpringApplication;
import org.springframework.boot.autoconfigure.SpringBootApplication;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.core.env.Environment;

import java.net.InetAddress;
import java.net.UnknownHostException;

@Slf4j
@EnableOss
@EnablePt
@SpringBootApplication
public class PtTobaccoLimsApplication {

  public static void main(String[] args) throws UnknownHostException {
    SpringApplication application = new SpringApplication(PtTobaccoLimsApplication.class);
    application.setBannerMode(Banner.Mode.CONSOLE);
      ConfigurableApplicationContext configurableApplicationContext = application.run(args);
    SpringHelper.setApplicationContext(configurableApplicationContext);

      Environment env = configurableApplicationContext.getEnvironment();
      String ip = InetAddress.getLocalHost().getHostAddress();
      String port = env.getProperty("server.port");
      log.info("PtTobaccoLimsApplication started"+"/\n\t"+
               "swagger-ui: \thttp://" + ip + ":" + port  + "/swagger-ui.html\n\t"
            );
  }
}

