package com.patzn.lims.common;

import com.patzn.lims.core.exception.PtException;
import com.patzn.lims.core.toolkit.JacksonUtils;
import jodd.bean.BeanCopy;

import java.io.Serializable;

/**
 * <p>
 * 基础实体转换
 * </p>
 *
 * @author hubin
 * @date 2017-06-12
 */
public class BaseConvert implements Serializable {

    private static final long serialVersionUID = 1L;

    /**
     * <p>
     * 获取自动转换后的JavaBean对象
     * </p>
     *
     * @param clazz 转换对象类
     * @param <T>   转换对象
     * @return
     */
    public <T> T convert(Class<T> clazz) {
        try {
            T t = clazz.newInstance();
            BeanCopy.beans(this, t).copy();
            return t;
        } catch (Exception e) {
            throw new PtException("转换对象失败", e);
        }
    }

    /**
     * 转为 JSON 字符串
     */
    public String toJson() {
        return JacksonUtils.toJSONString(this);
    }
}
