package com.patzn.lims.common;

import java.util.Calendar;
import java.util.Date;

/**
 * @author zhaokai
 * @since 2019-03-28
 */
public class CalendarUtils {

    public static Calendar getInstance(Date date) {
        if (null == date) {
            throw new NullPointerException("date cannot be null");
        }
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        return calendar;
    }

    /**
     * <p>
     * 比较calendar是否在another之前
     * </p>
     *
     * @param calendar
     * @param another
     * @return
     */
    public static boolean before(Calendar calendar, Calendar another) {
        return calendar.compareTo(another) < 0;
    }

    public static boolean before(Date d1, Date d2) {
        return getInstance(d1).compareTo(getInstance(d2)) < 0;
    }

    /**
     * <p>
     * 比较calendar是否在another之后
     * </p>
     *
     * @param calendar
     * @param another
     * @return
     */
    public static boolean after(Calendar calendar, Calendar another) {
        return calendar.compareTo(another) > 0;
    }

    public static boolean after(Date d1, Date d2) {
        return getInstance(d1).compareTo(getInstance(d2)) > 0;
    }

    /**
     * <p>
     * 比较calendar是否和another是同一天
     * </p>
     *
     * @param calendar
     * @param another
     * @return
     */
    public static boolean equals(Calendar calendar, Calendar another) {
        return calendar.compareTo(another) == 0;
    }

    public static boolean equals(Date d1, Date d2) {
        return getInstance(d1).compareTo(getInstance(d2)) == 0;
    }

    /**
     * <p>
     * calender加上数字为day的天数
     * </p>
     *
     * @param calendar 日期
     * @param day      天数，可以是正数也可以是负数
     */
    public static void calDay(Calendar calendar, int day) {
        int now = calendar.get(Calendar.DAY_OF_MONTH);
        calendar.set(Calendar.DAY_OF_MONTH, now + day);
    }

    /**
     * <p>
     * calender加上数字为month的月数
     * </p>
     *
     * @param calendar 日期
     * @param month    月数，可以是正数也可以是负数
     */
    public static void calMonth(Calendar calendar, int month) {
        int now = calendar.get(Calendar.MONTH);
        calendar.set(Calendar.MONTH, now + month);
    }

    /**
     * <p>
     * 任凭你随意两个日期，只要都不为空，就能给你计算出天数差
     * </p>
     *
     * @param c1
     * @param c2
     * @return
     */
    public static int sub(Calendar c1, Calendar c2) {
        return sub(c1, c2, true);
    }

    public static int sub(Calendar c1, Calendar c2, boolean abs) {
        if (c1 == null || c2 == null) {
            return 0;
        }
        int day1 = c1.get(Calendar.DAY_OF_YEAR);
        int day2 = c2.get(Calendar.DAY_OF_YEAR);
        int year1 = c1.get(Calendar.YEAR);
        int year2 = c2.get(Calendar.YEAR);
        if (year1 != year2) {
            //不同年
            int timeDistance = 0;
            if (year1 > year2) {
                year1 = year1 ^ year2;
                year2 = year1 ^ year2;
                year1 = year1 ^ year2;
            }
            for (int i = year1; i < year2; i++) {
                if (i % 4 == 0 && i % 100 != 0 || i % 400 == 0) {
                    //闰年
                    timeDistance += 366;
                } else {
                    // 不是闰年
                    timeDistance += 365;
                }
            }
            if (abs) {
                return timeDistance + Math.abs(day1 - day2);
            } else {
                return timeDistance + (day1 - day2);
            }
        } else {
            // 同年
            if (abs) {
                return Math.abs(day1 - day2);
            } else {
                return day1 - day2;
            }
        }
    }

    public static int sub(Date d1, Date d2) {
        return sub(d1, d2, true);
    }

    public static int sub(Date d1, Date d2, boolean abs) {
        if (d1 == null || d2 == null) {
            return 0;
        }
        Calendar c1 = getInstance(d1);
        Calendar c2 = getInstance(d2);
        return sub(c1, c2, abs);
    }
}
