package com.patzn.lims.common;

/**
 * <p>
 * 公共常量定义
 * </p>
 *
 * @author hubin
 * @since 2017-06-26
 */
public interface CommonConstants {

    String UTF8 = "UTF-8";
    String GET = "GET";
    String SYMBOL_DOT = ".";
    String SYMBOL_GANG = "/";
    String SYMBOL_JING = "#";
    String SYMBOL_DOU = ",";
    String SYMBOL_YU = "&";
    String SYMBOL_KUANG_YES = "☑";
    String SYMBOL_KUANG_NO = "□";
    String CONTENT_TYPE_JSON = "application/json; charset=UTF-8";

    /**
     * 报表按钮
     */
    String BUTTON_REPORT = "reportBtn";
    /**
     * 表单按钮
     */
    String BUTTON_FORM = "formBtn";

    /**
     * 黑名单缓存 KEY
     */
    String BLACK_CATCHE_KEY = "blackCatchKey#%s";

    /**
     * 序列号占位符
     */
    String SN = "#SN#";

    /**
     * 带字母序列号占位符
     */
    String NU = "#NU#";

    /**
     * Feign 服务名称
     */
    String FEIGN_BASE = "mapper.res";
    String FEIGN_RES = "mapper.res";
    String FEIGN_ENV = "env";
    String FEIGN_CONVERT = "convert";
    String FEIGN_STB = "statistics";

    /**
     * 是、否、默认
     */
    String YES = "Y";

    String NO = "N";

    String DEFAULT = "D";

    /**
     * 年月日的 format 格式
     */
    String YEAR_MONTH_DAY = "yyyy-MM-dd";
}
