package com.patzn.lims.common;

import java.util.*;

public final class StringStaticDataUtils {

    public static final String SUCCESS = "success";

    public static final String FALSE = "false";

    public static final String ZERO = "0";

    public static final String ONE = "1";

    public static final String JING = "#";

    public static final String SELECT_WAITING_ITEM = "请选择待提交的项目";


    public static final String CONTRACT_ID_NULL = "委托id未传递";


    public static final String CONTRACT_WRONG = "委托有误";


    public static final String SELECT_SAMPLE = "请选择样品";


    public static final String DATA_WRONG = "数据有误";


    public static final String MSG_TITLE_QC_TASK = "新的质控编制任务";

    public static final Map<String,List<String>> mapItemFlows=new HashMap<>();
    static {
        List<String> draftItemList=new ArrayList<>();
        draftItemList.add("ALLOT");
        draftItemList.add("INPUT");
        mapItemFlows.put("DRAFT",draftItemList);

        List<String> allotItemList=new ArrayList<>();
        allotItemList.add("INPUT");
        mapItemFlows.put("ALLOT",allotItemList);


        List<String> inputItemList=new ArrayList<>();
        inputItemList.add("REVIEW");
        inputItemList.add("AUDIT");
        inputItemList.add("COLLECT");
        mapItemFlows.put("INPUT",inputItemList);


        List<String> reviewItemList=new ArrayList<>();
        reviewItemList.add("AUDIT");
        reviewItemList.add("COLLECT");
        mapItemFlows.put("REVIEW",reviewItemList);


        List<String> auditItemList=new ArrayList<>();
        auditItemList.add("COLLECT");
        mapItemFlows.put("AUDIT",auditItemList);

        List<String> collectItemList=new ArrayList<>();
        collectItemList.add("END");
        mapItemFlows.put("COLLECT",collectItemList);
    }


    public static final Map<String,List<String>> mapFlows=new HashMap<>();
    static  {
        List<String> draftList=new ArrayList<>();
        draftList.add("SEARCH");
        draftList.add("PLAN");
        draftList.add("REVIEW");
        draftList.add("SIGN");
        draftList.add("SAMPLING_ARRANGE");
        mapFlows.put("DRAFT",draftList);

        List<String> searchList=new ArrayList<>();
        searchList.add("PLAN");
        searchList.add("REVIEW");
        searchList.add("SIGN");
        searchList.add("SAMPLING_ARRANGE");
        mapFlows.put("SEARCH",searchList);

        List<String> planList=new ArrayList<>();
        planList.add("PROJECT_LEADER");
        planList.add("REVIEW");
        planList.add("SIGN");
        planList.add("SAMPLING_ARRANGE");
        mapFlows.put("PLAN",planList);


        List<String> planCheckList=new ArrayList<>();
        planCheckList.add("REVIEW");
        planCheckList.add("SIGN");
        planCheckList.add("SAMPLING_ARRANGE");
        mapFlows.put("PROJECT_LEADER",planCheckList);

        List<String> reviewList=new ArrayList<>();
        reviewList.add("SIGN");
        reviewList.add("SAMPLING_ARRANGE");
        mapFlows.put("REVIEW",reviewList);


        List<String> signList=new ArrayList<>();
        signList.add("SAMPLING_ARRANGE");
        mapFlows.put("SIGN",signList);


        List<String> samplingArrangeList=new ArrayList<>();
        samplingArrangeList.add("SAMPLING");
        mapFlows.put("SAMPLING_ARRANGE",samplingArrangeList);

        List<String> samplingList=new ArrayList<>();
        samplingList.add("RECEIVE");
        mapFlows.put("SAMPLING",samplingList);

        List<String> receiveList=new ArrayList<>();
        receiveList.add("WAIT_QC");
        receiveList.add("TESTING");
        mapFlows.put("RECEIVE",receiveList);


        List<String> testingList=new ArrayList<>();
        receiveList.add("REPORT_ALLOT");
        mapFlows.put("TESTING",testingList);

        List<String> reportAllotList=new ArrayList<>();
        reportAllotList.add("REPORT_MAKE");
        mapFlows.put("REPORT_ALLOT",reportAllotList);

        List<String> reportMakeList=new ArrayList<>();
        reportMakeList.add("REPORT_CHECK");
        mapFlows.put("REPORT_MAKE",reportMakeList);


        List<String> reportCheckList=new ArrayList<>();
        reportCheckList.add("REPORT_ISSUE");
        mapFlows.put("REPORT_CHECK",reportCheckList);

        List<String> reportIssueList=new ArrayList<>();
        reportIssueList.add("REPORT_PRINT");
        mapFlows.put("REPORT_ISSUE",reportIssueList);


        List<String> reportPrintList=new ArrayList<>();
        reportPrintList.add("REPORT_FILE");
        mapFlows.put("REPORT_PRINT",reportPrintList);

        List<String> reportFileList=new ArrayList<>();
        reportFileList.add("END");
        mapFlows.put("REPORT_FILE",reportFileList);
    }


    public static final Map<String,String> mapFlowOption=new LinkedHashMap<>();
    static {
        mapFlowOption.put("DRAFT", "草稿");
        mapFlowOption.put("SEARCH", "现场调查");
        mapFlowOption.put("PLAN", "方案编制");
        mapFlowOption.put("PROJECT_LEADER", "项目负责人评审");
        mapFlowOption.put("TECHNOLOGY_LEADER", "技术负责人评审");
        mapFlowOption.put("REVIEW", "采样委托评审");
        mapFlowOption.put("SIGN", "采样委托签订");
        mapFlowOption.put("SAMPLING_ARRANGE", "采样任务安排");
        mapFlowOption.put("SAMPLING", "采样任务进行中");
        mapFlowOption.put("RECEIVE", "待样品接收发放");
        mapFlowOption.put("WAIT_QC", "待实验室加质控");
        mapFlowOption.put("TESTING", "实验室检测中");
        mapFlowOption.put("REPORT_ALLOT", "待报告编制分配");
        mapFlowOption.put("REPORT_MAKE", "待报告编制");
        mapFlowOption.put("REPORT_CHECK", "待报告审核");
        mapFlowOption.put("REPORT_ISSUE", "待报告签发");
        mapFlowOption.put("REPORT_PRINT", "待报告打印发放");
        mapFlowOption.put("REPORT_FILE", "待报告归档");
        mapFlowOption.put("END", "结束");

    }

    public static final Map<String,String> mapFlowItemOption=new LinkedHashMap<>();
    static {
        mapFlowItemOption.put("DRAFT", "初始");
        mapFlowItemOption.put("ALLOT", "待分配");
        mapFlowItemOption.put("CLAIM", "待认领");
        mapFlowItemOption.put("INPUT", "待数据录入");
        mapFlowItemOption.put("REVIEW", "待数据复核");
        mapFlowItemOption.put("AUDIT", "待数据审核");
        mapFlowItemOption.put("COLLECT", "数据汇总");
        mapFlowItemOption.put("END", "检测完成");
    }


    public static final List<String> reportModelList=new ArrayList<>();

    static {
        reportModelList.add("envReport.docx");
        reportModelList.add("envSendReport.docx");
        reportModelList.add("envSampleItemReport.docx");
    }
}
