package com.patzn.lims.config;

import com.baomidou.mybatisplus.core.handlers.MetaObjectHandler;
import com.patzn.lims.core.web.Account;
import com.patzn.lims.core.web.LoginHelper;
import org.apache.ibatis.reflection.MetaObject;

import java.util.Date;

/**
 * <p>
 * 自动填充逻辑
 * </p>
 *
 * @author hubin
 * @Date 2017-07-13
 */
public class BaseMetaObjectHandler implements MetaObjectHandler {

    /**
     * 公司 ID
     */
    private static final String COMPANY_ID = "companyId";
    /**
     * 操作人 ID
     */
    private static final String UID = "uid";
    /**
     * 创建时间
     */
    private static final String CREATE_TIME = "ctime";

    @Override
    public void insertFill(MetaObject metaObject) {
        Account account = LoginHelper.getAccountOrNull();
        if (null != account) {
            // 公司 ID
            if (metaObject.hasGetter(BaseMetaObjectHandler.COMPANY_ID) && null == metaObject.getValue(BaseMetaObjectHandler.COMPANY_ID)) {
                metaObject.setValue(BaseMetaObjectHandler.COMPANY_ID, account.getCompanyId());
            }
            // 操作人 ID
            if (metaObject.hasGetter(BaseMetaObjectHandler.UID)) {
                metaObject.setValue(BaseMetaObjectHandler.UID, account.getUserId());
            }
        }
        // 创建时间
        if (metaObject.hasGetter(BaseMetaObjectHandler.CREATE_TIME)) {
            metaObject.setValue(BaseMetaObjectHandler.CREATE_TIME, new Date());
        }
    }

    @Override
    public boolean openUpdateFill() {
        return false;
    }

    @Override
    public void updateFill(MetaObject metaObject) {
        // 不开启
    }
}
