//package com.patzn.lims.config;
//
//import com.github.benmanes.caffeine.cache.Caffeine;
//import com.github.benmanes.caffeine.cache.Ticker;
//import lombok.Data;
//import lombok.extern.slf4j.Slf4j;
//import org.springframework.boot.context.properties.ConfigurationProperties;
//import org.springframework.cache.CacheManager;
//import org.springframework.cache.annotation.EnableCaching;
//import org.springframework.cache.caffeine.CaffeineCache;
//import org.springframework.cache.support.SimpleCacheManager;
//import org.springframework.context.annotation.Bean;
//import org.springframework.context.annotation.Configuration;
//
//import java.util.List;
//import java.util.Map;
//import java.util.concurrent.TimeUnit;
//import java.util.stream.Collectors;
//
///**
// * Caffeine Config
// *
// * @author hubin
// * @since 2019-04-23
// */
//@Data
//@Slf4j
//@EnableCaching
//@Configuration
//@ConfigurationProperties(prefix = "spring.cache")
//public class CaffeineConfiguration {
//    @Data
//    public static class CacheSpec {
//        private Integer timeout;
//        private Integer max = 200;
//    }
//
//    private Map<String, CacheSpec> specs;
//
//    @Bean
//    public CacheManager cacheManager(Ticker ticker) {
//        SimpleCacheManager manager = new SimpleCacheManager();
//        if (specs != null) {
//            List<CaffeineCache> caches = specs.entrySet().stream()
//                    .map(entry -> buildCache(entry.getKey(), entry.getValue(), ticker))
//                    .collect(Collectors.toList());
//            manager.setCaches(caches);
//        }
//        return manager;
//    }
//
//    private CaffeineCache buildCache(String name, CacheSpec cacheSpec, Ticker ticker) {
//        log.info("Cache {} specified timeout of {} min, max of {}", name, cacheSpec.getTimeout(), cacheSpec.getMax());
//        final Caffeine<Object, Object> caffeineBuilder = Caffeine.newBuilder()
//                .expireAfterWrite(cacheSpec.getTimeout(), TimeUnit.MINUTES)
//                .maximumSize(cacheSpec.getMax())
//                .ticker(ticker);
//        return new CaffeineCache(name, caffeineBuilder.build());
//    }
//
//    @Bean
//    public Ticker ticker() {
//        return Ticker.systemTicker();
//    }
//}
