package com.patzn.lims.config;

import com.patzn.lims.core.api.PtResult;
import com.patzn.lims.core.exception.PtException;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.RestControllerAdvice;

/**
 * <p>
 * 通用 Api Controller 全局异常处理
 * </p>
 *
 * @author hubin
 * @since 2020-01-11
 */
@RestControllerAdvice
public class GlobalExceptionHandler {

    /**
     * <p>
     * 自定义 REST 业务异常
     * <p>
     *
     * @param e 异常类型
     * @return
     */
    @ExceptionHandler(value = Exception.class)
    public PtResult<Object> handleBadRequest(Exception e) {
        return PtException.handleBadRequest(e);
    }
}
