package com.patzn.lims.config;


import com.baomidou.mybatisplus.core.parser.ISqlParser;
import com.baomidou.mybatisplus.extension.parsers.BlockAttackSqlParser;
import com.baomidou.mybatisplus.extension.plugins.PaginationInterceptor;
import org.mybatis.spring.annotation.MapperScan;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.transaction.annotation.EnableTransactionManagement;

import java.util.ArrayList;

/**
 * <p>
 * MybatisPlus 配置
 * </p>
 *
 * @author hubin
 * @since 2017-03-31
 */
@EnableTransactionManagement
@Configuration
@MapperScan("com.patzn.lims.*.mapper*")
public class MybatisPlusConfig {

    /**
     * mybatis-plus分页插件<br>
     * 文档：http://mp.baomidou.com<br>
     */
    @Bean
    public PaginationInterceptor paginationInterceptor() {
        PaginationInterceptor paginationInterceptor = new PaginationInterceptor();
        paginationInterceptor.setSqlParserList(new ArrayList<ISqlParser>(){{
            add(new BlockAttackSqlParser());
        }});
        return paginationInterceptor;
    }

    /**
     * 自动填充
     */
    @Bean
    public BaseMetaObjectHandler baseMetaObjectHandler() {
        return new BaseMetaObjectHandler();
    }
}
