package com.patzn.lims.config;

import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import springfox.documentation.builders.PathSelectors;
import springfox.documentation.builders.RequestHandlerSelectors;
import springfox.documentation.service.ApiInfo;
import springfox.documentation.service.Contact;
import springfox.documentation.spi.DocumentationType;
import springfox.documentation.spring.web.plugins.ApiSelectorBuilder;
import springfox.documentation.spring.web.plugins.Docket;
import springfox.documentation.swagger2.annotations.EnableSwagger2;

import java.util.ArrayList;

/**
 * <p>
 * RESTful 服务 API 管理框架 Swagger 配置初始化 <br>
 * 官方地址：http://swagger.io<br>
 * </p>
 *
 * @author hubin
 * @date 2020-01-11
 */
@Configuration
@EnableSwagger2
@ConditionalOnProperty(prefix = "swagger", value = "enable")
public class SwaggerConfig {

    /**
     * 可以定义多个组，比如本类中定义把test和demo区分开了 （访问页面就可以看到效果了）
     */
    @Bean
    public Docket testApi() {
        ApiSelectorBuilder asb = new Docket(DocumentationType.SWAGGER_2)
                .apiInfo(this.apiInfo()).select();
        asb.apis(RequestHandlerSelectors.basePackage("com.patzn.lims.*.controller"));
        asb.paths(PathSelectors.any());
        return asb.build();
    }

    private ApiInfo apiInfo() {
        return new ApiInfo("Pt Service API",
                "Pt 服务 API",
                "1.0",
                "NO terms of service",
                new Contact("帕特智能", "", ""),
                "帕特智能 OPS 云",
                "http://www.patzn.com"
                , new ArrayList()
        );
    }
}
