package com.patzn.lims.consume.controller;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.patzn.lims.common.Tree;
import com.patzn.lims.consume.vo.LmsChemicalCategoryVO;
import com.patzn.lims.core.PtConstants;
import com.patzn.lims.core.api.PtResult;
import com.patzn.lims.core.web.ServiceController;
import com.patzn.lims.consume.entity.LmsChemicalCategory;
import com.patzn.lims.consume.service.ILmsChemicalCategoryService;
import com.patzn.lims.equip.entity.LmsEquipLocation;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import org.springframework.web.bind.annotation.*;

import java.util.List;

/**
 * <p>
 * 试验耗材分类表 前端控制器
 * </p>
 *
 * @author wwd
 * @since 2020-03-21
 */
@Api(tags = "试验耗材分类表")
@RestController
@RequestMapping("/v1/chemical_category")
public class LmsChemicalCategoryController extends ServiceController<ILmsChemicalCategoryService, LmsChemicalCategory> {

    @ApiOperation(value = "分页列表", notes = "分页查询数据列表")
    @ApiImplicitParams({
            @ApiImplicitParam(name = PtConstants.PAGE_PAGE, value = "请求数据的页码", required = true, paramType = "query", dataType = "int"),
            @ApiImplicitParam(name = PtConstants.PAGE_ROWS, value = "每页条数", required = true, paramType = "query", dataType = "int"),
            @ApiImplicitParam(name = PtConstants.PAGE_SIDX, value = "排序字段", paramType = "query", dataType = "String"),
            @ApiImplicitParam(name = PtConstants.PAGE_SORD, value = "排序方式", paramType = "query", dataType = "String"),
    })
    @PostMapping("/page")
	public PtResult<IPage<LmsChemicalCategoryVO>> getPage(LmsChemicalCategoryVO vo) {
        return success(baseService.pageVO(getPage(), vo));
	}


    @ApiOperation(value = "获取仪器类别树", notes = "获取仪器类别树")
    @PutMapping("/get_tree")
    public PtResult<List<Tree>> getTree(LmsChemicalCategory lmsChemicalCategory) {
        return success(baseService.getTree(lmsChemicalCategory));
    }


    @ApiOperation(value = "查询分类树", notes = "查询分类数据列表")
    @GetMapping("/category_tree_all")
    public PtResult<List<LmsChemicalCategory>> getCategoryAllTree(String name) {
        return success(baseService.getCategoryAllTree(name));
    }


    @ApiOperation(value = "查询 roleId 的分类列表", notes = "查询 roleId 的分类数据列表")
    @PostMapping("/list_include_role/{roleId}")
    public PtResult<List<LmsChemicalCategory>> getListIncludeRole(@PathVariable("roleId") Long roleId) {
        return success(baseService.listIncludeRoleId(roleId));
    }


    @ApiOperation(value = "添加角色关联耗材分类", notes = "添加角色关联耗材分类")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "roleId", value = "角色主键", required = true, paramType = "path", dataType = "long"),
            @ApiImplicitParam(name = "categoryIds", value = "耗材分类主键集合", required = true, paramType = "query", dataType = "array"),
    })
    @PostMapping("/role_category/{roleId}")
    public PtResult<Boolean> addRoleRelCategory(@PathVariable("roleId") Long roleId, Long[] categoryIds) {
        return success(baseService.saveRoleCategory(roleId, categoryIds));
    }

}
