package com.patzn.lims.consume.controller;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.patzn.lims.core.PtConstants;
import com.patzn.lims.core.api.PtResult;
import com.patzn.lims.core.web.ServiceController;
import com.patzn.lims.consume.entity.LmsChemicalClassify;
import com.patzn.lims.consume.service.ILmsChemicalClassifyService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import org.springframework.web.bind.annotation.*;

import java.util.List;

/**
 * <p>
 * 试验耗材归类表 前端控制器
 * </p>
 *
 * @author wwd
 * @since 2020-03-25
 */
@Api(tags = "试验耗材归类表")
@RestController
@RequestMapping("/v1/chemical_classify")
public class LmsChemicalClassifyController extends ServiceController<ILmsChemicalClassifyService, LmsChemicalClassify> {

    @ApiOperation(value = "分页列表", notes = "分页查询数据列表")
    @ApiImplicitParams({
            @ApiImplicitParam(name = PtConstants.PAGE_PAGE, value = "请求数据的页码", required = true, paramType = "query", dataType = "int"),
            @ApiImplicitParam(name = PtConstants.PAGE_ROWS, value = "每页条数", required = true, paramType = "query", dataType = "int"),
            @ApiImplicitParam(name = PtConstants.PAGE_SIDX, value = "排序字段", paramType = "query", dataType = "String"),
            @ApiImplicitParam(name = PtConstants.PAGE_SORD, value = "排序方式", paramType = "query", dataType = "String"),
    })
    @PostMapping("/page")
	public PtResult<IPage<LmsChemicalClassify>> getPage(LmsChemicalClassify lmsChemicalClassify) {
        return success(baseService.page(getPage(), lmsChemicalClassify));
	}



    @ApiOperation(value = "保存耗材归类", notes = "给指定 归类 ID 添加相关类型的耗材")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "classifyId", value = "归类 ID", required = true, paramType = "path", dataType = "long"),
            @ApiImplicitParam(name = "chemicalIds", value = "耗材数组", required = true, paramType = "query", dataType = "array"),
    })
    @PostMapping("/rel_chemical_{classifyId}")
    public PtResult<Boolean> addRelChemical(@PathVariable("classifyId") Long classifyId, @RequestParam("chemicalIds") List<Long> chemicalIds) {
        return success(baseService.saveRelChemical(classifyId, chemicalIds));
    }


    @ApiOperation(value = "移除耗材归类", notes = "给指定 归类 ID 移除相关类型的耗材")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "classifyId", value = "归类 ID", required = true, paramType = "path", dataType = "long"),
            @ApiImplicitParam(name = "chemicalIds", value = "耗材数组", required = true, paramType = "query", dataType = "array"),
    })
    @DeleteMapping("/rel_chemical_{classifyId}")
    public PtResult<Boolean> deleteRelChemical(@PathVariable("classifyId") Long classifyId, @RequestParam("chemicalIds") List<Long> chemicalIds) {
        return success(baseService.removeRelChemical(classifyId, chemicalIds));
    }

}
