package com.patzn.lims.consume.controller;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.patzn.lims.consume.dto.LmsChemicalDTO;
import com.patzn.lims.consume.vo.LmsChemicalVO;
import com.patzn.lims.core.PtConstants;
import com.patzn.lims.core.api.PtResult;
import com.patzn.lims.core.web.ServiceController;
import com.patzn.lims.consume.entity.LmsChemical;
import com.patzn.lims.consume.service.ILmsChemicalService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

/**
 * <p>
 * 试验耗材表 前端控制器
 * </p>
 *
 * @author wwd
 * @since 2020-03-21
 */
@Api(tags = "试验耗材表")
@RestController
@RequestMapping("/v1/chemical")
public class LmsChemicalController extends ServiceController<ILmsChemicalService, LmsChemical> {

    @ApiOperation(value = "分页列表", notes = "分页查询数据列表")
    @ApiImplicitParams({
            @ApiImplicitParam(name = PtConstants.PAGE_PAGE, value = "请求数据的页码", required = true, paramType = "query", dataType = "int"),
            @ApiImplicitParam(name = PtConstants.PAGE_ROWS, value = "每页条数", required = true, paramType = "query", dataType = "int"),
            @ApiImplicitParam(name = PtConstants.PAGE_SIDX, value = "排序字段", paramType = "query", dataType = "String"),
            @ApiImplicitParam(name = PtConstants.PAGE_SORD, value = "排序方式", paramType = "query", dataType = "String"),
    })
    @PostMapping("/page")
    public PtResult<IPage<LmsChemicalDTO>> getPage(LmsChemicalDTO dto) {
        return success(baseService.page(getPage(),getAccount(), dto));
    }


    @ApiOperation(value = "分页列表", notes = "分页查询数据列表")
    @ApiImplicitParams({
            @ApiImplicitParam(name = PtConstants.PAGE_PAGE, value = "请求数据的页码", required = true, paramType = "query", dataType = "int"),
            @ApiImplicitParam(name = PtConstants.PAGE_ROWS, value = "每页条数", required = true, paramType = "query", dataType = "int"),
            @ApiImplicitParam(name = PtConstants.PAGE_SIDX, value = "排序字段", paramType = "query", dataType = "String"),
            @ApiImplicitParam(name = PtConstants.PAGE_SORD, value = "排序方式", paramType = "query", dataType = "String"),
    })
    @PostMapping("/page_vo")
    public PtResult<IPage<LmsChemicalVO>> getPage(LmsChemicalVO vo) {
        return success(baseService.pageVO(getPage(), vo));
    }



    @ApiOperation(value = "归类包含耗材", notes = "归类包含耗材分页信息")
    @ApiImplicitParams({
            @ApiImplicitParam(name = PtConstants.PAGE_PAGE, value = "请求数据的页码", required = true, paramType = "query", dataType = "int"),
            @ApiImplicitParam(name = PtConstants.PAGE_ROWS, value = "每页条数", required = true, paramType = "query", dataType = "int"),
            @ApiImplicitParam(name = PtConstants.PAGE_SIDX, value = "排序字段", paramType = "query", dataType = "String"),
            @ApiImplicitParam(name = PtConstants.PAGE_SORD, value = "排序方式", paramType = "query", dataType = "String"),
            @ApiImplicitParam(name = "classifyId", value = "归类 ID", required = true, paramType = "path", dataType = "long"),
    })
    @PostMapping("/page_include_classify/{classifyId}")
    public PtResult<IPage<LmsChemical>> pageIncludeClassify(@PathVariable("classifyId") Long classifyId, LmsChemical lmsChemical) {
        return success(baseService.pageIncludeClassify(getPage(), classifyId, lmsChemical));
    }



    @ApiOperation(value = "归类不包含耗材", notes = "归类不包含耗材分页信息")
    @ApiImplicitParams({
            @ApiImplicitParam(name = PtConstants.PAGE_PAGE, value = "请求数据的页码", required = true, paramType = "query", dataType = "int"),
            @ApiImplicitParam(name = PtConstants.PAGE_ROWS, value = "每页条数", required = true, paramType = "query", dataType = "int"),
            @ApiImplicitParam(name = PtConstants.PAGE_SIDX, value = "排序字段", paramType = "query", dataType = "String"),
            @ApiImplicitParam(name = PtConstants.PAGE_SORD, value = "排序方式", paramType = "query", dataType = "String"),
            @ApiImplicitParam(name = "classifyId", value = "归类 ID", required = true, paramType = "path", dataType = "long"),
    })
    @PostMapping("/page_exclude_classify/{classifyId}")
    public PtResult<IPage<LmsChemical>> pageExcludeClassify(@PathVariable("classifyId") Long classifyId, LmsChemical lmsChemical) {
        lmsChemical.setUid(currentUserId());
        return success(baseService.pageExcludeClassify(getPage(), getAccount(), classifyId, lmsChemical));
    }

}
