package com.patzn.lims.consume.controller;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.patzn.lims.consume.dto.LmsChemicalDeliveryOrderDTO;
import com.patzn.lims.consume.vo.LmsChemicalDeliveryOrderVO;
import com.patzn.lims.core.PtConstants;
import com.patzn.lims.core.api.PtResult;
import com.patzn.lims.core.web.ServiceController;
import com.patzn.lims.consume.entity.LmsChemicalDeliveryOrder;
import com.patzn.lims.consume.service.ILmsChemicalDeliveryOrderService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

/**
 * <p>
 * 试验耗材出库单表 前端控制器
 * </p>
 *
 * @author wwd
 * @since 2020-03-25
 */
@Api(tags = "试验耗材出库单表")
@RestController
@RequestMapping("/v1/chemical_delivery_order")
public class LmsChemicalDeliveryOrderController extends ServiceController<ILmsChemicalDeliveryOrderService, LmsChemicalDeliveryOrder> {

    @ApiOperation(value = "分页列表", notes = "分页查询数据列表")
    @ApiImplicitParams({
            @ApiImplicitParam(name = PtConstants.PAGE_PAGE, value = "请求数据的页码", required = true, paramType = "query", dataType = "int"),
            @ApiImplicitParam(name = PtConstants.PAGE_ROWS, value = "每页条数", required = true, paramType = "query", dataType = "int"),
            @ApiImplicitParam(name = PtConstants.PAGE_SIDX, value = "排序字段", paramType = "query", dataType = "String"),
            @ApiImplicitParam(name = PtConstants.PAGE_SORD, value = "排序方式", paramType = "query", dataType = "String"),
    })
    @PostMapping("/page")
	public PtResult<IPage<LmsChemicalDeliveryOrder>> getPage(LmsChemicalDeliveryOrderVO lmsChemicalDeliveryOrder) {
        return success(baseService.page(getPage(), lmsChemicalDeliveryOrder));
	}



    @ApiOperation(value = "添加出库单", notes = "添加出库单自动提交关联记录")
    @PostMapping("/{approve}")
    public PtResult<Boolean> add(@PathVariable("approve") boolean approve, LmsChemicalDeliveryOrderDTO lmsChemicalDeliveryOrder) {
        return success(baseService.save(approve, lmsChemicalDeliveryOrder,lmsChemicalDeliveryOrder.getSendUserId()));
    }


    @ApiOperation(value = "添加出库单审核", notes = "添加出库单工作流进入审批阶段")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "ids", value = "主键 ID 集合", required = true, paramType = "query", dataType = "array"),
    })
    @PostMapping("/flow_submit")
    public PtResult<Boolean> submitPurchaseFlow(Long[] ids,Long sendUserId) {
        return success(null != baseService.submitDeliveryFlow(ids,sendUserId));
    }


    @ApiOperation(value = "审核出库单", notes = "审核出库单工作流")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "taskId", value = "任务 ID", required = true, paramType = "path", dataType = "string"),
            @ApiImplicitParam(name = "allow", value = "审批类型", required = true, paramType = "query", dataType = "string"),
            @ApiImplicitParam(name = "postil", value = "审核批注", paramType = "query", dataType = "string"),
            @ApiImplicitParam(name = "step", value = "步骤", paramType = "query", dataType = "string"),
    })
    @PostMapping("/flow_approve/{taskId}")
    public PtResult<Boolean> approvePurchaseFlow(@PathVariable("taskId") String taskId, String allow, String postil, String step) {
        return success(baseService.approveDeliveryFlow(taskId, allow, postil, step));
    }

    @ApiOperation(value = "新二级审核出库单", notes = "新二级审核出库单")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "taskId", value = "任务 ID", required = true, paramType = "path", dataType = "string"),
            @ApiImplicitParam(name = "allow", value = "审批类型", required = true, paramType = "query", dataType = "string"),
            @ApiImplicitParam(name = "postil", value = "审核批注", paramType = "query", dataType = "string"),
            @ApiImplicitParam(name = "orderId", value = "出库单ID", paramType = "path", dataType = "long"),
    })
    @PostMapping("/news_flow_approve/{taskId}")
    public PtResult<Boolean> approvePurchaseFlowNews(@PathVariable("taskId") String taskId, String postil, String allow,Long orderId,Long userId) {
        return success(baseService.approvePurchaseFlowNews(taskId, postil,allow,orderId,userId));
    }



    @ApiOperation(value = "审批完成待出库单分页列表", notes = "分页查询审批完成待出库单数据列表")
    @ApiImplicitParams({
            @ApiImplicitParam(name = PtConstants.PAGE_PAGE, value = "请求数据的页码", required = true, paramType = "query", dataType = "int"),
            @ApiImplicitParam(name = PtConstants.PAGE_ROWS, value = "每页条数", required = true, paramType = "query", dataType = "int"),
            @ApiImplicitParam(name = PtConstants.PAGE_SIDX, value = "排序字段", paramType = "query", dataType = "String"),
            @ApiImplicitParam(name = PtConstants.PAGE_SORD, value = "排序方式", paramType = "query", dataType = "String"),
    })
    @PostMapping("/page_wait_delivery")
    public PtResult<IPage<LmsChemicalDeliveryOrder>> pageWaitPurchase(LmsChemicalDeliveryOrderVO lmsChemicalDeliveryOrder) {
        //要求是用户获取所有已经处理的申请
        // lmsChemicalDeliveryOrder.setUid(this.currentUserId());
        return success(baseService.pageWaitDelivery(getPage(), lmsChemicalDeliveryOrder));
    }

}
