package com.patzn.lims.consume.controller;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.patzn.lims.consume.dto.PurchaseOrderSaveDTO;
import com.patzn.lims.consume.vo.LmsChemicalPurchaseOrderVO;
import com.patzn.lims.core.PtConstants;
import com.patzn.lims.core.api.PtResult;
import com.patzn.lims.core.web.ServiceController;
import com.patzn.lims.consume.entity.LmsChemicalPurchaseOrder;
import com.patzn.lims.consume.service.ILmsChemicalPurchaseOrderService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

/**
 * <p>
 * 试验耗材采购单表 前端控制器
 * </p>
 *
 * @author wwd
 * @since 2020-03-21
 */
@Api(tags = "试验耗材采购单表")
@RestController
@RequestMapping("/v1/chemical_purchase_order")
public class LmsChemicalPurchaseOrderController extends ServiceController<ILmsChemicalPurchaseOrderService, LmsChemicalPurchaseOrder> {

    @ApiOperation(value = "分页列表", notes = "分页查询数据列表")
    @ApiImplicitParams({
            @ApiImplicitParam(name = PtConstants.PAGE_PAGE, value = "请求数据的页码", required = true, paramType = "query", dataType = "int"),
            @ApiImplicitParam(name = PtConstants.PAGE_ROWS, value = "每页条数", required = true, paramType = "query", dataType = "int"),
            @ApiImplicitParam(name = PtConstants.PAGE_SIDX, value = "排序字段", paramType = "query", dataType = "String"),
            @ApiImplicitParam(name = PtConstants.PAGE_SORD, value = "排序方式", paramType = "query", dataType = "String"),
    })
    @PostMapping("/page")
	public PtResult<IPage<LmsChemicalPurchaseOrder>> getPage(LmsChemicalPurchaseOrder lmsChemicalPurchaseOrder) {
        return success(baseService.page(getPage(), lmsChemicalPurchaseOrder));
	}


    @ApiOperation(value = "添加采购单", notes = "添加采购单自动提交关联记录")
    @PostMapping("/save_order")
    public PtResult<Boolean> add(PurchaseOrderSaveDTO dto) {
        return success(baseService.save(dto.getRemark(),dto.getSendUserId(),getAccount()));
    }




    @ApiOperation(value = "分页列表", notes = "分页查询数据列表")
    @ApiImplicitParams({
            @ApiImplicitParam(name = PtConstants.PAGE_PAGE, value = "请求数据的页码", required = true, paramType = "query", dataType = "int"),
            @ApiImplicitParam(name = PtConstants.PAGE_ROWS, value = "每页条数", required = true, paramType = "query", dataType = "int"),
            @ApiImplicitParam(name = PtConstants.PAGE_SIDX, value = "排序字段", paramType = "query", dataType = "String"),
            @ApiImplicitParam(name = PtConstants.PAGE_SORD, value = "排序方式", paramType = "query", dataType = "String"),
    })
    @PostMapping("/page-purchase-order")
    public PtResult<IPage<LmsChemicalPurchaseOrderVO>> getPagePurchaseOrder(LmsChemicalPurchaseOrderVO vo) {
        vo.setCompanyId(getAccount().getCompanyId());
        return success(baseService.pageVO(getPage(), vo));
    }


    @ApiOperation(value = "审批完成待采购单分页列表", notes = "分页查询审批完成待采购单数据列表")
    @ApiImplicitParams({
            @ApiImplicitParam(name = PtConstants.PAGE_PAGE, value = "请求数据的页码", required = true, paramType = "query", dataType = "int"),
            @ApiImplicitParam(name = PtConstants.PAGE_ROWS, value = "每页条数", required = true, paramType = "query", dataType = "int"),
            @ApiImplicitParam(name = PtConstants.PAGE_SIDX, value = "排序字段", paramType = "query", dataType = "String"),
            @ApiImplicitParam(name = PtConstants.PAGE_SORD, value = "排序方式", paramType = "query", dataType = "String"),
    })
    @PostMapping("/page-wait-purchase")
    public PtResult<IPage<LmsChemicalPurchaseOrderVO>> pageWaitPurchase(LmsChemicalPurchaseOrderVO lmsChemicalPurchaseOrder) {
        return success(baseService.pageWaitPurchase(getPage(), lmsChemicalPurchaseOrder));
    }


    @ApiOperation(value = "添加采购单审核", notes = "添加采购单工作流进入审批阶段")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "ids", value = "主键 ID 集合", required = true, paramType = "query", dataType = "array"),
    })
    @PostMapping("/flow_submit")
    public PtResult<Boolean> submitPurchaseFlow(Long[] ids,Long  sendUserId) {
        return success(null != baseService.submitPurchaseFlow(ids,sendUserId,getAccount()));
    }



    @ApiOperation(value = "实验室主任审批", notes = "实验室主任审批")
    @PostMapping("/approve/{taskId}")
    public PtResult<Boolean> approve(@PathVariable("taskId") String taskId, String allow, String postil, Long id, Long sendUserId) {
        return success(baseService.approveFlow(taskId, allow, postil,id,sendUserId));
    }



}
