package com.patzn.lims.consume.controller;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.patzn.lims.consume.entity.LmsChemicalUserecord;
import com.patzn.lims.consume.vo.LmsChemicalRelDeliveryVO;
import com.patzn.lims.core.PtConstants;
import com.patzn.lims.core.api.PtResult;
import com.patzn.lims.core.web.ServiceController;
import com.patzn.lims.consume.entity.LmsChemicalRelDelivery;
import com.patzn.lims.consume.service.ILmsChemicalRelDeliveryService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import org.springframework.web.bind.annotation.*;

import java.math.BigDecimal;

/**
 * <p>
 * 试验耗材采购关联表 前端控制器
 * </p>
 *
 * @author wwd
 * @since 2020-03-25
 */
@Api(tags = "试验耗材采购关联表")
@RestController
@RequestMapping("/v1/chemical_rel_delivery")
public class LmsChemicalRelDeliveryController extends ServiceController<ILmsChemicalRelDeliveryService, LmsChemicalRelDelivery> {

    @ApiOperation(value = "分页列表", notes = "分页查询数据列表")
    @ApiImplicitParams({
            @ApiImplicitParam(name = PtConstants.PAGE_PAGE, value = "请求数据的页码", required = true, paramType = "query", dataType = "int"),
            @ApiImplicitParam(name = PtConstants.PAGE_ROWS, value = "每页条数", required = true, paramType = "query", dataType = "int"),
            @ApiImplicitParam(name = PtConstants.PAGE_SIDX, value = "排序字段", paramType = "query", dataType = "String"),
            @ApiImplicitParam(name = PtConstants.PAGE_SORD, value = "排序方式", paramType = "query", dataType = "String"),
    })
    @PostMapping("/page")
	public PtResult<IPage<LmsChemicalRelDelivery>> getPage(LmsChemicalRelDelivery lmsChemicalRelDelivery) {
        return success(baseService.page(getPage(), lmsChemicalRelDelivery));
	}

    @ApiOperation(value = "添加至出库单", notes = "添加一条数据至出库单")
    @PostMapping("/")
    public PtResult<Boolean> add(LmsChemicalRelDelivery lmsChemicalRelDelivery) {
        return success(baseService.saveOutOrder(lmsChemicalRelDelivery));
    }



    @ApiOperation(value = "临时出库单分页列表", notes = "分页查询临时出库单数据列表")
    @ApiImplicitParams({
            @ApiImplicitParam(name = PtConstants.PAGE_PAGE, value = "请求数据的页码", required = true, paramType = "query", dataType = "int"),
            @ApiImplicitParam(name = PtConstants.PAGE_ROWS, value = "每页条数", required = true, paramType = "query", dataType = "int"),
            @ApiImplicitParam(name = PtConstants.PAGE_SIDX, value = "排序字段", paramType = "query", dataType = "String"),
            @ApiImplicitParam(name = PtConstants.PAGE_SORD, value = "排序方式", paramType = "query", dataType = "String"),
    })
    @PostMapping("/page_temp")
    public PtResult<IPage<LmsChemicalRelDeliveryVO>> getPageTemp(LmsChemicalRelDeliveryVO lmsChemicalRelDelivery) {
        // 临时出库列表
        lmsChemicalRelDelivery.setUid(currentUserId());
        lmsChemicalRelDelivery.setStatus(0);
        return success(baseService.pageTempBySql(getPage(), lmsChemicalRelDelivery));
    }




    @ApiOperation(value = "审批耗材出库单分页列表", notes = "分页查询数据列表")
    @ApiImplicitParams({
            @ApiImplicitParam(name = PtConstants.PAGE_PAGE, value = "请求数据的页码", required = true, paramType = "query", dataType = "int"),
            @ApiImplicitParam(name = PtConstants.PAGE_ROWS, value = "每页条数", required = true, paramType = "query", dataType = "int"),
            @ApiImplicitParam(name = PtConstants.PAGE_SIDX, value = "排序字段", paramType = "query", dataType = "String"),
            @ApiImplicitParam(name = PtConstants.PAGE_SORD, value = "排序方式", paramType = "query", dataType = "String"),
    })
    @PostMapping("/page_approve_order_id")
    public  PtResult<IPage<LmsChemicalRelDeliveryVO>>  getPageByApproveOrderId(LmsChemicalRelDeliveryVO lmsChemicalRelPurchase) {
        return success(baseService.pageTempBySql(getPage(), lmsChemicalRelPurchase));
    }



    @ApiOperation(value = "分页列表", notes = "分页查询数据列表")
    @ApiImplicitParams({
            @ApiImplicitParam(name = PtConstants.PAGE_PAGE, value = "请求数据的页码", required = true, paramType = "query", dataType = "int"),
            @ApiImplicitParam(name = PtConstants.PAGE_ROWS, value = "每页条数", required = true, paramType = "query", dataType = "int"),
            @ApiImplicitParam(name = PtConstants.PAGE_SIDX, value = "排序字段", paramType = "query", dataType = "String"),
            @ApiImplicitParam(name = PtConstants.PAGE_SORD, value = "排序方式", paramType = "query", dataType = "String"),
    })
    @PostMapping("/page_order_id")
    public PtResult<IPage<LmsChemicalRelDeliveryVO>> getPageByOrderId(LmsChemicalRelDelivery lmsChemicalRelPurchase) {
        lmsChemicalRelPurchase.setUid(this.currentUserId());
        return success(baseService.getPageByOrderId(getPage(), lmsChemicalRelPurchase));
    }



    @ApiOperation(value = "修改待提交审批出库信息", notes = "根据指定 id 修改该条待提交审批出库数据内容")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "id", value = "主键", required = true, paramType = "path", dataType = "long"),
            @ApiImplicitParam(name = "quantity", value = "数量", required = true, paramType = "query", dataType = "BigDecimal"),
    })
    @PutMapping("/wait_approval_{id}")
    public PtResult<Boolean> editWaitApplyId(@PathVariable("id") Long id, @RequestParam("quantity") BigDecimal quantity) {
        return success(baseService.updateWaitApprovalId(id, quantity));
    }


    @ApiOperation(value = "耗材快速出库", notes = "出库单所有数据从库存出库，并结束出库单")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "orderId", value = "出库单主键", required = true, paramType = "path", dataType = "long"),
    })
    @PostMapping("/out_all_stock_{orderId}")
    public PtResult<Boolean> deleteAllStock(@PathVariable("orderId") Long orderId, LmsChemicalUserecord userecord) {
        return success(baseService.removeAllStock(getAccount(), orderId,userecord));
    }


}
