package com.patzn.lims.consume.controller;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.patzn.lims.consume.vo.LmsChemicalRelPurchaseVO;
import com.patzn.lims.core.PtConstants;
import com.patzn.lims.core.api.PtResult;
import com.patzn.lims.core.web.ServiceController;
import com.patzn.lims.consume.entity.LmsChemicalRelPurchase;
import com.patzn.lims.consume.service.ILmsChemicalRelPurchaseService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

/**
 * <p>
 * 试验耗材采购关联表 前端控制器
 * </p>
 *
 * @author wwd
 * @since 2020-03-21
 */
@Api(tags = "试验耗材采购关联表")
@RestController
@RequestMapping("/v1/chemical_rel_purchase")
public class LmsChemicalRelPurchaseController extends ServiceController<ILmsChemicalRelPurchaseService, LmsChemicalRelPurchase> {

    @ApiOperation(value = "分页列表", notes = "分页查询数据列表")
    @ApiImplicitParams({
            @ApiImplicitParam(name = PtConstants.PAGE_PAGE, value = "请求数据的页码", required = true, paramType = "query", dataType = "int"),
            @ApiImplicitParam(name = PtConstants.PAGE_ROWS, value = "每页条数", required = true, paramType = "query", dataType = "int"),
            @ApiImplicitParam(name = PtConstants.PAGE_SIDX, value = "排序字段", paramType = "query", dataType = "String"),
            @ApiImplicitParam(name = PtConstants.PAGE_SORD, value = "排序方式", paramType = "query", dataType = "String"),
    })
    @PostMapping("/page")
	public PtResult<IPage<LmsChemicalRelPurchaseVO>> getPage(LmsChemicalRelPurchaseVO lmsChemicalRelPurchase) {
        return success(baseService.page(getPage(), lmsChemicalRelPurchase));
	}


    @ApiOperation(value = "临时采购单分页列表", notes = "分页查询临时采购单数据列表")
    @ApiImplicitParams({
            @ApiImplicitParam(name = PtConstants.PAGE_PAGE, value = "请求数据的页码", required = true, paramType = "query", dataType = "int"),
            @ApiImplicitParam(name = PtConstants.PAGE_ROWS, value = "每页条数", required = true, paramType = "query", dataType = "int"),
            @ApiImplicitParam(name = PtConstants.PAGE_SIDX, value = "排序字段", paramType = "query", dataType = "String"),
            @ApiImplicitParam(name = PtConstants.PAGE_SORD, value = "排序方式", paramType = "query", dataType = "String"),
    })
    @PostMapping("/page_temp")
    public PtResult<IPage<LmsChemicalRelPurchaseVO>> getPageTemp(LmsChemicalRelPurchaseVO lmsChemicalRelPurchase) {
        lmsChemicalRelPurchase.setUid(this.currentUserId());
        return success(baseService.pageTemp(getPage(), lmsChemicalRelPurchase));
    }


    @ApiOperation(value = "添加采购", notes = "添加一条采购数据")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "chemicalIds", value = "主键数组", required = true, paramType = "query", dataType = "array"),
    })
    @PostMapping("/")
    public PtResult<Boolean> add(@RequestParam("chemicalIds") Long[] chemicalIds, LmsChemicalRelPurchase chemicalRelPurchase) {
        return success(baseService.saveByChemicalIds(chemicalIds, chemicalRelPurchase));
    }


    @ApiOperation(value = "采购完成", notes = "采购完成")
    @PostMapping("/finish_purchase")
    public PtResult<Boolean> finishPurchase(@RequestParam("ids") Long[] ids) {
        return success(baseService.finishPurchase(ids));
    }


    @ApiOperation(value = "分页列表", notes = "分页查询数据列表")
    @ApiImplicitParams({
            @ApiImplicitParam(name = PtConstants.PAGE_PAGE, value = "请求数据的页码", required = true, paramType = "query", dataType = "int"),
            @ApiImplicitParam(name = PtConstants.PAGE_ROWS, value = "每页条数", required = true, paramType = "query", dataType = "int"),
            @ApiImplicitParam(name = PtConstants.PAGE_SIDX, value = "排序字段", paramType = "query", dataType = "String"),
            @ApiImplicitParam(name = PtConstants.PAGE_SORD, value = "排序方式", paramType = "query", dataType = "String"),
    })
    @PostMapping("/page-order-id")
    public PtResult<IPage<LmsChemicalRelPurchaseVO>> getPageByOrderId(LmsChemicalRelPurchaseVO vo) {
        vo.setUid(this.currentUserId());
        return success(baseService.getPageByOrderId(getPage(), vo));
    }

}
