package com.patzn.lims.consume.controller;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.patzn.lims.core.api.PtResult;
import com.patzn.lims.consume.dto.LmsChemicalStockDTO;
import com.patzn.lims.core.PtConstants;

import com.patzn.lims.core.web.ServiceController;
import com.patzn.lims.consume.entity.LmsChemicalStock;
import com.patzn.lims.consume.service.ILmsChemicalStockService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import org.springframework.web.bind.annotation.*;

/**
 * <p>
 * 试验耗材库存表 前端控制器
 * </p>
 *
 * @author wwd
 * @since 2020-03-24
 */
@Api(tags = "试验耗材库存表")
@RestController
@RequestMapping("/v1/chemical_stock")
public class LmsChemicalStockController extends ServiceController<ILmsChemicalStockService, LmsChemicalStock> {

    @ApiOperation(value = "分页列表", notes = "分页查询数据列表")
    @ApiImplicitParams({
            @ApiImplicitParam(name = PtConstants.PAGE_PAGE, value = "请求数据的页码", required = true, paramType = "query", dataType = "int"),
            @ApiImplicitParam(name = PtConstants.PAGE_ROWS, value = "每页条数", required = true, paramType = "query", dataType = "int"),
            @ApiImplicitParam(name = PtConstants.PAGE_SIDX, value = "排序字段", paramType = "query", dataType = "String"),
            @ApiImplicitParam(name = PtConstants.PAGE_SORD, value = "排序方式", paramType = "query", dataType = "String"),
    })
    @PostMapping("/page")
    public PtResult<IPage<LmsChemicalStockDTO>> getPage(LmsChemicalStockDTO dto) {
        return success(baseService.page(getPage(), dto));
    }


    @ApiOperation(value = "根据 id 修改信息", notes = "根据指定 id 修改该条数据内容")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "id", value = "主键", required = true, paramType = "path", dataType = "long"),
            @ApiImplicitParam(name = "type", value = "类型 0、采购入库 1、使用出库 2、归还入库", required = true, paramType = "query", dataType = "Integer"),
    })
    @PutMapping("/edit")
    public PtResult<Boolean> edit(LmsChemicalStockDTO dto) {
        return success(baseService.updateDTOById(dto));
    }

    @ApiOperation(value = "根据 id 修改信息", notes = "根据指定 id 修改该条数据内容")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "id", value = "主键", required = true, paramType = "path", dataType = "long"),
            @ApiImplicitParam(name = "type", value = "类型 0、采购入库 1、使用出库 2、归还入库", required = true, paramType = "query", dataType = "Integer"),
    })
    @PutMapping("/{id}")
    public PtResult<Boolean> edit(@PathVariable("id") Long id, LmsChemicalStockDTO dto) {
        dto.setId(id);
        return success(baseService.updateDTOById(dto));
    }

    @ApiOperation(value = "添加台账入库", notes = "添加一条数据")
    @PostMapping("/tz_in_stock")
    public PtResult<Boolean> tzInStock(LmsChemicalStockDTO dto) {
        return success(baseService.saveDTO(dto));

    }


}
