package com.patzn.lims.consume.controller;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.patzn.lims.consume.vo.LmsChemicalUserecordVO;
import com.patzn.lims.core.PtConstants;
import com.patzn.lims.core.api.PtResult;
import com.patzn.lims.core.web.ServiceController;
import com.patzn.lims.consume.entity.LmsChemicalUserecord;
import com.patzn.lims.consume.service.ILmsChemicalUserecordService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

/**
 * <p>
 * 耗材使用记录表 前端控制器
 * </p>
 *
 * @author wwd
 * @since 2020-03-24
 */
@Api(tags = "耗材使用记录表")
@RestController
@RequestMapping("/v1/chemical_userecord")
public class LmsChemicalUserecordController extends ServiceController<ILmsChemicalUserecordService, LmsChemicalUserecord> {

    @ApiOperation(value = "分页列表", notes = "分页查询数据列表")
    @ApiImplicitParams({
            @ApiImplicitParam(name = PtConstants.PAGE_PAGE, value = "请求数据的页码", required = true, paramType = "query", dataType = "int"),
            @ApiImplicitParam(name = PtConstants.PAGE_ROWS, value = "每页条数", required = true, paramType = "query", dataType = "int"),
            @ApiImplicitParam(name = PtConstants.PAGE_SIDX, value = "排序字段", paramType = "query", dataType = "String"),
            @ApiImplicitParam(name = PtConstants.PAGE_SORD, value = "排序方式", paramType = "query", dataType = "String"),
    })
    @PostMapping("/page")
	public PtResult<IPage<LmsChemicalUserecordVO>> getPage(LmsChemicalUserecordVO lmsChemicalUserecord) {
        return success(baseService.pageVO(getPage(), lmsChemicalUserecord));
	}


    @ApiOperation(value = "查询耗材ID分页列表", notes = "分页查询耗材ID指定数据列表")
    @ApiImplicitParams({
            @ApiImplicitParam(name = PtConstants.PAGE_PAGE, value = "请求数据的页码", required = true, paramType = "query", dataType = "int"),
            @ApiImplicitParam(name = PtConstants.PAGE_ROWS, value = "每页条数", required = true, paramType = "query", dataType = "int"),
            @ApiImplicitParam(name = PtConstants.PAGE_SIDX, value = "排序字段", paramType = "query", dataType = "String"),
            @ApiImplicitParam(name = PtConstants.PAGE_SORD, value = "排序方式", paramType = "query", dataType = "String"),
    })
    @PostMapping("/page_{chemicalId}")
    public PtResult<IPage<LmsChemicalUserecordVO>> getPageByChemicalId(@PathVariable("chemicalId") Long chemicalId, LmsChemicalUserecordVO vo) {
        vo.setChemicalId(chemicalId);
        return success(baseService.pageVO(getPage(), vo));
    }

}
