package com.patzn.lims.consume.dto;
import com.patzn.lims.consume.entity.LmsChemical;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.experimental.Accessors;

import java.math.BigDecimal;
import java.util.List;

/**
 * <p>
 * 试验耗材 DTO
 * </p>
 *
 * @author hubin
 * @since 2017-10-10
 */
@Data
@Accessors(chain = true)
@ApiModel
public class LmsChemicalDTO extends LmsChemical {

    @ApiModelProperty(value = "供应商 ID 集合“ ,”逗号分隔")
    private String supplierIds;

    @ApiModelProperty(value = "查询要求存在库存")
    private boolean existStock = false;

    @ApiModelProperty(value = "单价")
    private BigDecimal unitPrice;

    @ApiModelProperty(value = "耗材id的list")
    private List<Long> ids;

    @ApiModelProperty(value = "入库的库存")
    private String inStock;

    @ApiModelProperty("入库制造厂商")
    private String inManufacturer;

    @ApiModelProperty("供应商")
    private String supplier;

    @ApiModelProperty("生产批号")
    private String batchNum;

    @ApiModelProperty("有效期")
    private String validDate;

    @ApiModelProperty("商品编码")
    private String productCode;

    @ApiModelProperty("CAS编码")
    private String casNum;

    @ApiModelProperty("累计出库量")
    private BigDecimal allOutStock;

}
