package com.patzn.lims.consume.dto;

import com.patzn.lims.consume.entity.LmsChemicalStock;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.experimental.Accessors;

import java.math.BigDecimal;
import java.util.Date;

/**
 * <p>
 * 耗材库存 DTO
 * </p>
 *
 * @author hubin
 * @date 2017-12-22
 */
@Data
@Accessors(chain = true)
@ApiModel
public class LmsChemicalStockDTO extends LmsChemicalStock {

    @ApiModelProperty("单价")
    private BigDecimal price;

    @ApiModelProperty("库存量")
    private BigDecimal allstock;

    @ApiModelProperty("仓库位置")
    private String storehouse;

    @ApiModelProperty(value = "类型 类型 0、入库 1、出库 2、归还")
    private Integer type;

    @ApiModelProperty(value = "科室 ID")
    private Long depId;

    @ApiModelProperty(value = "科室")
    private String department;

    @ApiModelProperty(value = "登记人")
    private String registrant;

    @ApiModelProperty(value = "登记日期")
    private Date regdate;

    @ApiModelProperty("操作人")
    private String realname;

    @ApiModelProperty("有效时间")
    private Date validDate;

    @ApiModelProperty(value = "开始有效期")
    private Date beginValidDate;

    @ApiModelProperty(value = "结束有效期")
    private Date endValidDate;

    @ApiModelProperty(value = "采购单明细主键")
    private Long purchaseOrderRelId;

    @ApiModelProperty(value = "入库原因")
    private String reason;

    @ApiModelProperty(value = "批次库存量")
    private BigDecimal batchStock;

    @ApiModelProperty(value = "距离有效期（/天）")
    private int validDay;

    @ApiModelProperty(value = "采购单 ID")
    private Long orderId;

    @ApiModelProperty(value = "验收人 ID")
    private Long checkPersonId;

    @ApiModelProperty(value = "验收人")
    private String checkPerson;

    @ApiModelProperty(value = "不合格数量")
    private BigDecimal unqualifiedQuantity;

    @ApiModelProperty(value = "不合格原因")
    private String unqualifiedReason;

    @ApiModelProperty("耗材类别")
    private String category;

    @ApiModelProperty("耗材编号")
    private String num;

    @ApiModelProperty("耗材名称")
    private String name;
}
