package com.patzn.lims.consume.entity;

import java.math.BigDecimal;
import java.util.Date;
import com.patzn.lims.core.bean.BaseEntity;
import com.baomidou.mybatisplus.annotation.FieldFill;
import com.baomidou.mybatisplus.annotation.TableLogic;
import com.baomidou.mybatisplus.annotation.TableField;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.experimental.Accessors;

/**
 * <p>
 * 试验耗材表
 * </p>
 *
 * @author wwd
 * @since 2020-03-21
 */
@Data
@Accessors(chain = true)
@ApiModel
public class LmsChemical extends BaseEntity {

    @ApiModelProperty(value = "企业 ID")
	@TableField(fill = FieldFill.INSERT)
	private Long companyId;
    @ApiModelProperty(value = "创建人 ID")
	@TableField(fill = FieldFill.INSERT)
	private Long uid;
    @ApiModelProperty(value = "分类 ID")
	private Long categoryId;
    @ApiModelProperty(value = "分类")
	private String category;
    @ApiModelProperty(value = "名称")
	private String name;
    @ApiModelProperty(value = "库存")
	private BigDecimal stock;
    @ApiModelProperty(value = "单位")
	private String unit;
    @ApiModelProperty(value = "转换库存")
	private BigDecimal exstock;
    @ApiModelProperty(value = "转换率")
	private BigDecimal exchange;
    @ApiModelProperty(value = "转换单位")
	private String exunit;
    @ApiModelProperty(value = "规格")
	private String spec;
    @ApiModelProperty(value = "密度")
	private String thickness;
    @ApiModelProperty(value = "制造厂商")
	private String manufacturer;
    @ApiModelProperty(value = "纯度")
	private String quality;
    @ApiModelProperty(value = "标准值")
	private String standard;
    @ApiModelProperty(value = "不确定度")
	private String unsure;
    @ApiModelProperty(value = "状态（0、禁用 1、正常）")
	private Integer status;
    @ApiModelProperty(value = "0、正常 1、删除")
    @TableLogic
	private Integer deleted;
    @ApiModelProperty(value = "最后修改人 ID")
	@TableField(fill = FieldFill.UPDATE)
	private Long lid;
    @ApiModelProperty(value = "最后修改时间")
	@TableField(fill = FieldFill.UPDATE)
	private Date ltime;
    @ApiModelProperty(value = "创建时间")
	@TableField(fill = FieldFill.INSERT)
	private Date ctime;
    @ApiModelProperty(value = "库存是否归类")
	private Integer classifyed;
    @ApiModelProperty(value = "单价")
	private BigDecimal unitPrice;
    @ApiModelProperty(value = "拼音")
	private String pinyin;
    @ApiModelProperty(value = "编码")
	private String num;
    @ApiModelProperty(value = "仓库位置")
	private String storehouse;
    @ApiModelProperty(value = "备注")
	private String remark;
	private BigDecimal lowerStock;
    @ApiModelProperty(value = "使用部门")
	private String useDepartment;
    @ApiModelProperty(value = "保存条件")
	private String saveCondition;
    @ApiModelProperty(value = "保管人")
	private String saver;
    @ApiModelProperty(value = "保管人id")
	private String saverId;


}
