package com.patzn.lims.consume.entity;

import java.util.Date;
import com.patzn.lims.core.bean.BaseEntity;
import com.baomidou.mybatisplus.annotation.FieldFill;
import com.baomidou.mybatisplus.annotation.TableLogic;
import com.baomidou.mybatisplus.annotation.TableField;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.experimental.Accessors;

/**
 * <p>
 * 耗材附件表
 * </p>
 *
 * @author wwd
 * @since 2020-03-21
 */
@Data
@Accessors(chain = true)
@ApiModel
public class LmsChemicalAttachment extends BaseEntity {

    @ApiModelProperty(value = "公司 ID")
	private Long companyId;
    @ApiModelProperty(value = "耗材 ID")
	private Long chemicalId;
    @ApiModelProperty(value = "文件名")
	private String fileName;
    @ApiModelProperty(value = "桶名称")
	private String bucketName;
    @ApiModelProperty(value = "对象 key")
	private String objectKey;
    @ApiModelProperty(value = "版本号")
	private String versionId;
    @ApiModelProperty(value = "创建人 ID")
	@TableField(fill = FieldFill.INSERT)
	private Long uid;
    @ApiModelProperty(value = "创建时间")
	@TableField(fill = FieldFill.INSERT)
	private Date ctime;
    @ApiModelProperty(value = "文件类型")
	private String type;
    @ApiModelProperty(value = "备注")
	private String remark;
    @ApiModelProperty(value = "创建人")
	private String cname;
    @TableLogic
	private Integer deleted;


}
