package com.patzn.lims.consume.entity;

import java.util.Date;
import com.patzn.lims.core.bean.BaseEntity;
import com.baomidou.mybatisplus.annotation.FieldFill;
import com.baomidou.mybatisplus.annotation.TableField;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.experimental.Accessors;

/**
 * <p>
 * 试验耗材分类表
 * </p>
 *
 * @author wwd
 * @since 2020-03-21
 */
@Data
@Accessors(chain = true)
@ApiModel
public class LmsChemicalCategory extends BaseEntity {

    @ApiModelProperty(value = "父 ID")
	private Long pid;
    @ApiModelProperty(value = "企业 ID")
	private Long companyId;
    @ApiModelProperty(value = "创建人 ID")
	@TableField(fill = FieldFill.INSERT)
	private Long uid;
    @ApiModelProperty(value = "名称")
	private String name;
    @ApiModelProperty(value = "状态（0、禁用 1、正常）")
	private Integer status;
    @ApiModelProperty(value = "最后修改人 ID")
	@TableField(fill = FieldFill.UPDATE)
	private Long lid;
    @ApiModelProperty(value = "最后修改时间")
	@TableField(fill = FieldFill.UPDATE)
	private Date ltime;
    @ApiModelProperty(value = "创建时间")
	@TableField(fill = FieldFill.INSERT)
	private Date ctime;
    @ApiModelProperty(value = "编码")
	private String num;
    @ApiModelProperty(value = "备注")
	private String remark;
    @ApiModelProperty(value = "拼音首字母")
	private String pinyin;


}
