package com.patzn.lims.consume.entity;

import java.math.BigDecimal;
import java.util.Date;
import com.patzn.lims.core.bean.BaseEntity;
import com.baomidou.mybatisplus.annotation.FieldFill;
import com.baomidou.mybatisplus.annotation.TableField;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.experimental.Accessors;

/**
 * <p>
 * 试验耗材归类表
 * </p>
 *
 * @author wwd
 * @since 2020-03-25
 */
@Data
@Accessors(chain = true)
@ApiModel
public class LmsChemicalClassify extends BaseEntity {
	@TableField(fill = FieldFill.INSERT)
    @ApiModelProperty(value = "企业 ID")
	private Long companyId;
    @ApiModelProperty(value = "操作人 ID")
	@TableField(fill = FieldFill.INSERT)
	private Long uid;
    @ApiModelProperty(value = "名称")
	private String name;
    @ApiModelProperty(value = "库存量")
	private BigDecimal stock;
    @ApiModelProperty(value = "单位")
	private String unit;
    @ApiModelProperty(value = "最后更新人 ID")
	@TableField(fill = FieldFill.UPDATE)
	private Long lid;
    @ApiModelProperty(value = "最后更新时间")
	@TableField(fill = FieldFill.UPDATE)
	private Date ltime;
    @ApiModelProperty(value = "创建时间")
	@TableField(fill = FieldFill.INSERT)
	private Date ctime;
    @ApiModelProperty(value = "拼音首字母")
	private String pinyin;
    @ApiModelProperty(value = "预警值")
	private BigDecimal warning;
    @ApiModelProperty(value = "备注")
	private String remark;
    @ApiModelProperty(value = "通知 0、否 1、是")
	private Integer inform;
    @ApiModelProperty(value = "预警的消息通知类型 0 PC消息 1 微信 2短信")
	private String informType;


}
