package com.patzn.lims.consume.entity;

import java.math.BigDecimal;
import java.util.Date;
import com.patzn.lims.core.bean.BaseEntity;
import com.baomidou.mybatisplus.annotation.FieldFill;
import com.baomidou.mybatisplus.annotation.TableField;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.experimental.Accessors;

/**
 * <p>
 * 试验耗材采购关联表
 * </p>
 *
 * @author wwd
 * @since 2020-03-25
 */
@Data
@Accessors(chain = true)
@ApiModel
public class LmsChemicalRelDelivery extends BaseEntity {
	@TableField(fill = FieldFill.INSERT)
    @ApiModelProperty(value = "企业 ID")
	private Long companyId;
    @ApiModelProperty(value = "创建人 ID")
	@TableField(fill = FieldFill.INSERT)
	private Long uid;
    @ApiModelProperty(value = "库存 ID")
	private Long stockId;
    @ApiModelProperty(value = "采购单 ID")
	private Long orderId;
    @ApiModelProperty(value = "耗材 ID")
	private Long chemicalId;
    @ApiModelProperty(value = "耗材名称")
	private String chemicalName;
    @ApiModelProperty(value = "采购量")
	private BigDecimal quantity;
    @ApiModelProperty(value = "已入库量")
	private BigDecimal alreadyQuantity;
    @ApiModelProperty(value = "制造厂商")
	private String manufacturer;
    @ApiModelProperty(value = "规格")
	private String spec;
    @ApiModelProperty(value = "价格")
	private BigDecimal price;
    @ApiModelProperty(value = "供应商ID")
	private Long supplierId;
    @ApiModelProperty(value = "供应商")
	private String supplier;
    @ApiModelProperty(value = "备注")
	private String remark;
    @ApiModelProperty(value = "审批状态 0、正常 1、驳回 2、调整")
	private Integer state;
    @ApiModelProperty(value = "状态 0、待入库 1、入库")
	private Integer status;
    @ApiModelProperty(value = "创建时间")
	@TableField(fill = FieldFill.INSERT)
	private Date ctime;
    @ApiModelProperty(value = "耗材编号")
	private String chemicalNum;
    @ApiModelProperty(value = "有效时间")
	private Date validDate;
    @ApiModelProperty(value = "批次")
	private String batchNum;
    @ApiModelProperty(value = "计量单位")
	private String unit;
    @ApiModelProperty(value = "商品编码")
	private String productCode;


}
