package com.patzn.lims.consume.entity;

import java.math.BigDecimal;
import java.util.Date;
import com.patzn.lims.core.bean.BaseEntity;
import com.baomidou.mybatisplus.annotation.FieldFill;
import com.baomidou.mybatisplus.annotation.TableLogic;
import com.baomidou.mybatisplus.annotation.TableField;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.experimental.Accessors;

/**
 * <p>
 * 试验耗材库存表
 * </p>
 *
 * @author wwd
 * @since 2020-03-24
 */
@Data
@Accessors(chain = true)
@ApiModel
public class LmsChemicalStock extends BaseEntity {
	@TableField(fill = FieldFill.INSERT)
    @ApiModelProperty(value = "企业 ID")
	private Long companyId;
    @ApiModelProperty(value = "试验耗材 ID")
	private Long chemicalId;
    @ApiModelProperty(value = "有效期")
	private Date validDate;
    @ApiModelProperty(value = "使用地点")
	private String useSite;
    @ApiModelProperty(value = "CAS编号")
	private String casNum;
    @ApiModelProperty(value = "精度范围")
	private String accuracyRange;
    @ApiModelProperty(value = "证书编号")
	private String certificateNum;
    @ApiModelProperty(value = "使用范围")
	private String useRange;
    @ApiModelProperty(value = "设备管理员")
	private String manage;
    @ApiModelProperty(value = "已使用量")
	private BigDecimal used;
    @ApiModelProperty(value = "库存")
	private BigDecimal stock;
    @ApiModelProperty(value = "单位")
	private String unit;
    @ApiModelProperty(value = "转换库存")
	private BigDecimal exstock;
    @ApiModelProperty(value = "转换单位")
	private String exunit;
    @ApiModelProperty(value = "备注")
	private String remark;
    @ApiModelProperty(value = "0、正常 1、删除")
    @TableLogic
	private Integer deleted;
    @ApiModelProperty(value = "最后修改人 ID")
	@TableField(fill = FieldFill.UPDATE)
	private Long lid;
    @ApiModelProperty(value = "最后修改时间")
	@TableField(fill = FieldFill.UPDATE)
	private Date ltime;
    @ApiModelProperty(value = "创建时间")
	@TableField(fill = FieldFill.INSERT)
	private Date ctime;
    @ApiModelProperty(value = "供应商")
	private String supplier;
    @ApiModelProperty(value = "已使用转化量")
	private BigDecimal exused;
    @ApiModelProperty(value = "批号")
	private String batchNum;
    @ApiModelProperty(value = "供应商 ID")
	private Long supplierId;
    @ApiModelProperty(value = "商品编码")
	private String productCode;
    @ApiModelProperty(value = "制造厂商")
	private String manufacturer;
    @ApiModelProperty(value = "状态")
	private Integer state;
    @ApiModelProperty(value = "耗材过期处理申请id")
	private Long applyId;
    @ApiModelProperty(value = "单价")
	private BigDecimal unitPrice;
    @ApiModelProperty(value = "规格型号")
	private String spec;


}
