package com.patzn.lims.consume.entity;

import java.math.BigDecimal;
import java.util.Date;
import com.patzn.lims.core.bean.BaseEntity;
import com.baomidou.mybatisplus.annotation.FieldFill;
import com.baomidou.mybatisplus.annotation.TableLogic;
import com.baomidou.mybatisplus.annotation.TableField;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.experimental.Accessors;

/**
 * <p>
 * 耗材使用记录表
 * </p>
 *
 * @author wwd
 * @since 2020-03-24
 */
@Data
@Accessors(chain = true)
@ApiModel
public class LmsChemicalUserecord extends BaseEntity {
	@TableField(fill = FieldFill.INSERT)
    @ApiModelProperty(value = "企业 ID")
	private Long companyId;
    @ApiModelProperty(value = "入库 ID")
	private Long stockId;
    @ApiModelProperty(value = "登记人 ID")
	@TableField(fill = FieldFill.INSERT)
	private Long uid;
    @ApiModelProperty(value = "类型 0、入库 1、出库 2、归还")
	private Integer type;
    @ApiModelProperty(value = "出入库量")
	private BigDecimal stock;
    @ApiModelProperty(value = "单位")
	private String unit;
    @ApiModelProperty(value = "转换单位")
	private String exunit;
    @ApiModelProperty(value = "转换出入库量")
	private BigDecimal exstock;
    @ApiModelProperty(value = "科室")
	private String department;
    @ApiModelProperty(value = "登记人")
	private String registrant;
    @ApiModelProperty(value = "备注")
	private String remark;
    @ApiModelProperty(value = "0、正常 1、删除")
    @TableLogic
	private Integer deleted;
    @ApiModelProperty(value = "登记时间")
	@TableField(fill = FieldFill.INSERT)
	private Date ctime;
    @ApiModelProperty(value = "耗材 ID")
	private Long chemicalId;
    @ApiModelProperty(value = "单价")
	private BigDecimal price;
    @ApiModelProperty(value = "库存量")
	private BigDecimal allstock;
    @ApiModelProperty(value = "批号")
	private String batchNum;
    @ApiModelProperty(value = "仓库位置")
	private String storehouse;
    @ApiModelProperty(value = "操作人")
	private String realname;
    @ApiModelProperty(value = "有效期")
	private Date validDate;
    @ApiModelProperty(value = "登记日期")
	private Date regdate;
    @ApiModelProperty(value = "科室 ID")
	private Long depId;
    @ApiModelProperty(value = "進出庫原因")
	private String reason;
    @ApiModelProperty(value = "批次库存量")
	private BigDecimal  batchstock;
    @ApiModelProperty(value = "不合格数量")
	private BigDecimal unqualifiedQuantity;
    @ApiModelProperty(value = "不合格原因")
	private String unqualifiedReason;
    @ApiModelProperty(value = "验收人id")
	private Long checkPersonId;
    @ApiModelProperty(value = "验收人")
	private String checkPerson;
    @ApiModelProperty(value = "采购单id")
	private Long orderId;
    @ApiModelProperty(value = "被修正数据的id")
	private Long amendedId;


}
