package com.patzn.lims.consume.enums;

import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.patzn.lims.core.enums.JsonEnumDeserializer;

import java.io.Serializable;

/**
 * <p>
 * 出库单状态枚举
 * </p>
 *
 * @author hubin
 * @since 2017-12-23
 */
@JsonDeserialize(using = JsonEnumDeserializer.class)
public enum DeliveryOrderEnum  {
    /**
     * 待审批
     */
    WAIT_APPROVAL(0, "待提交"),
     /**
     * 审批中
     */
    IN_APPROVAL(1, "审批中"),
    /**
     * 审批未通过
     */
    APPROVAL_FAILED(2, "审批未通过"),
    /**
     * 待出库
     */
    WAIT_DELIVERY(3, "待出库"),
    /**
     * 完成
     */
    FINISH(4, "完成"),
    /**
     * 审批驳回
     */
    APPROVAL_REJECT(5, "审批驳回"),

    /**
     * 下级审批中
     */
    SECONDARY_APPROVAL(15, "下级审批中");

    private int value;
    private String display;

    DeliveryOrderEnum(final int value, final String display) {
        this.value = value;
        this.display = display;
    }

    public Serializable getValue() {
        return this.value;
    }

    public String getName() {
        return this.name();
    }

    public String getDisplay() {
        return this.display;
    }
}