package com.patzn.lims.consume.enums;

/**
 * <p>
 * 出库单关联耗材状态枚举
 * </p>
 *
 * @author hubin
 * @since 2017-12-23
 */
public enum DeliveryRelStateEnum {
    /**
     * 正常
     */
    NORMAL(0, "正常"),
    /**
     * 驳回
     */
    REJECT(1, "驳回"),
    /**
     * 调整
     */
    ADJUST(2, "调整"),
    /**
     * 结束
     */
    FINISH(3, "结束");

    private int value;
    private String display;

    DeliveryRelStateEnum(final int value, final String display) {
        this.value = value;
        this.display = display;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name();
    }

    public String getDisplay() {
        return this.display;
    }
}